/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.spotify.helios.common.Resolver;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PeriodicResolver
implements Supplier<List<URI>> {
    private List<URI> endpoints;

    private PeriodicResolver(String srvName, String domain, Resolver resolver, ScheduledExecutorService executorService) {
        this.endpoints = resolver.resolve(srvName, domain);
        executorService.scheduleWithFixedDelay(() -> {
            this.endpoints = resolver.resolve(srvName, domain);
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    public static PeriodicResolver create(String srvName, String domain, ScheduledExecutorService executorService) {
        return new PeriodicResolver(srvName, domain, new Resolver(), executorService);
    }

    @VisibleForTesting
    public static PeriodicResolver create(String srvName, String domain, Resolver resolver, ScheduledExecutorService executorService) {
        return new PeriodicResolver(srvName, domain, resolver, executorService);
    }

    public List<URI> get() {
        return this.endpoints;
    }
}

