/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.Descriptor;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RolloutTask
extends Descriptor {
    private final Action action;
    private final String target;

    public static RolloutTask of(Action action, String target) {
        return new RolloutTask(action, target);
    }

    private RolloutTask(@JsonProperty(value="action") Action action, @JsonProperty(value="target") String target) {
        this.action = (Action)((Object)Preconditions.checkNotNull((Object)((Object)action), (Object)"action"));
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
    }

    public Action getAction() {
        return this.action;
    }

    public String getTarget() {
        return this.target;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "RolloutTask{action=" + (Object)((Object)this.action) + ", target='" + this.target + '\'' + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolloutTask that = (RolloutTask)o;
        if (this.action != that.action) {
            return false;
        }
        return !(this.target == null ? that.target != null : !this.target.equals(that.target));
    }

    public int hashCode() {
        int result = this.action != null ? this.action.hashCode() : 0;
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Action action;
        private String target;

        public Builder setAction(Action action) {
            this.action = action;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public RolloutTask build() {
            return new RolloutTask(this.action, this.target);
        }
    }

    public static enum Status {
        OK,
        FAILED;

    }

    public static enum Action {
        UNDEPLOY_OLD_JOBS,
        DEPLOY_NEW_JOB,
        AWAIT_RUNNING,
        FORCE_UNDEPLOY_JOBS,
        AWAIT_UNDEPLOYED,
        MARK_UNDEPLOYED;

    }
}

