/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.spotify.helios.client.Endpoint;
import com.spotify.helios.client.EndpointIterator;
import com.spotify.helios.client.HostnameVerifierProvider;
import com.spotify.helios.client.HttpConnector;
import com.spotify.helios.client.HttpsHandler;
import com.spotify.helios.common.HeliosException;
import com.spotify.helios.common.Json;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpConnector
implements HttpConnector {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpConnector.class);
    private final EndpointIterator endpointIterator;
    private final HostnameVerifierProvider hostnameVerifierProvider;
    private final int httpTimeoutMillis;
    private HttpsHandler extraHttpsHandler;

    public DefaultHttpConnector(EndpointIterator endpointIterator, int httpTimeoutMillis, boolean sslHostnameVerificationEnabled) {
        this.endpointIterator = endpointIterator;
        this.httpTimeoutMillis = httpTimeoutMillis;
        this.hostnameVerifierProvider = new HostnameVerifierProvider(sslHostnameVerificationEnabled, (HostnameVerifier)new DefaultHostnameVerifier());
        this.extraHttpsHandler = null;
    }

    @Override
    public HttpURLConnection connect(URI uri, String method, byte[] entity, Map<String, List<String>> headers) throws HeliosException {
        Endpoint endpoint = this.endpointIterator.next();
        String endpointHost = endpoint.getUri().getHost();
        try {
            HttpURLConnection connection = this.connect0(uri, method, entity, headers, endpointHost);
            if (connection.getResponseCode() == 502) {
                throw new HeliosException(String.format("Request to %s returned %s, master is down", uri, connection.getResponseCode()));
            }
            return connection;
        }
        catch (ConnectException | SocketTimeoutException | UnknownHostException e) {
            log.debug(e.toString());
            throw new HeliosException("Unable to connect to master: " + uri, e);
        }
        catch (IOException e) {
            throw new HeliosException("Unexpected error connecting to " + uri, e);
        }
    }

    private HttpURLConnection connect0(URI ipUri, String method, byte[] entity, Map<String, List<String>> headers, String endpointHost) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("req: {} {} {} {} {} {}", new Object[]{method, ipUri, headers.size(), Joiner.on((char)',').withKeyValueSeparator("=").join(headers), entity.length, Json.asPrettyStringUnchecked(entity)});
        } else {
            log.debug("req: {} {} {} {}", new Object[]{method, ipUri, headers.size(), entity.length});
        }
        HttpURLConnection connection = (HttpURLConnection)ipUri.toURL().openConnection();
        DefaultHttpConnector.handleHttps(connection, endpointHost, this.hostnameVerifierProvider, this.extraHttpsHandler);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(this.httpTimeoutMillis);
        connection.setReadTimeout(this.httpTimeoutMillis);
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            for (String value : header.getValue()) {
                connection.addRequestProperty(header.getKey(), value);
            }
        }
        if (entity.length > 0) {
            connection.setDoOutput(true);
            connection.getOutputStream().write(entity);
        }
        DefaultHttpConnector.setRequestMethod(connection, method, connection instanceof HttpsURLConnection);
        return connection;
    }

    private static void handleHttps(HttpURLConnection connection, String hostname, HostnameVerifierProvider hostnameVerifierProvider, HttpsHandler extraHttpsHandler) {
        if (!(connection instanceof HttpsURLConnection)) {
            return;
        }
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        connection.setRequestProperty("Host", hostname);
        HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
        httpsConnection.setHostnameVerifier(hostnameVerifierProvider.verifierFor(hostname));
        if (extraHttpsHandler != null) {
            extraHttpsHandler.handle(httpsConnection);
        }
    }

    private static void setRequestMethod(HttpURLConnection connection, String method, boolean isHttps) {
        Class<?> httpURLConnectionClass = connection.getClass();
        try {
            Field methodField;
            HttpURLConnection delegate;
            if (isHttps) {
                Field delegateField = httpURLConnectionClass.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                delegate = (HttpURLConnection)delegateField.get(connection);
                methodField = delegate.getClass().getSuperclass().getSuperclass().getSuperclass().getDeclaredField("method");
            } else {
                delegate = connection;
                methodField = httpURLConnectionClass.getSuperclass().getDeclaredField("method");
            }
            methodField.setAccessible(true);
            methodField.set(delegate, method);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public void setExtraHttpsHandler(HttpsHandler extraHttpsHandler) {
        this.extraHttpsHandler = extraHttpsHandler;
    }
}

