/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.client.Endpoint;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endpoints {
    private static final Logger log = LoggerFactory.getLogger(Endpoints.class);
    private static final DnsResolver DEFAULT_DNS_RESOLVER = SystemDefaultDnsResolver.INSTANCE;

    private Endpoints() {
    }

    public static Supplier<List<Endpoint>> of(Supplier<List<URI>> uriSupplier) {
        return Endpoints.of(uriSupplier, DEFAULT_DNS_RESOLVER);
    }

    static Supplier<List<Endpoint>> of(final Supplier<List<URI>> uriSupplier, final DnsResolver dnsResolver) {
        return new Supplier<List<Endpoint>>(){

            public List<Endpoint> get() {
                return Endpoints.of((List)uriSupplier.get(), dnsResolver);
            }
        };
    }

    public static List<Endpoint> of(List<URI> uris) {
        return Endpoints.of(uris, DEFAULT_DNS_RESOLVER);
    }

    static List<Endpoint> of(List<URI> uris, DnsResolver dnsResolver) {
        ImmutableList.Builder endpoints = ImmutableList.builder();
        for (URI uri : uris) {
            try {
                for (InetAddress ip : dnsResolver.resolve(uri.getHost())) {
                    endpoints.add((Object)new DefaultEndpoint(uri, ip));
                }
            }
            catch (UnknownHostException e) {
                log.warn("Unable to resolve hostname {} into IP address", (Object)uri.getHost(), (Object)e);
            }
        }
        return endpoints.build();
    }

    private static class DefaultEndpoint
    implements Endpoint {
        private static final List<String> VALID_PROTOCOLS = ImmutableList.of((Object)"http", (Object)"https");
        private static final String VALID_PROTOCOLS_STR = String.format("[%s]", Joiner.on((String)"|").join(VALID_PROTOCOLS));
        private final InetAddress ip;
        private final URI uri;

        DefaultEndpoint(URI uri, InetAddress ip) {
            this.uri = (URI)Preconditions.checkNotNull((Object)uri);
            this.ip = (InetAddress)Preconditions.checkNotNull((Object)ip);
            String scheme = this.uri.getScheme();
            String host = this.uri.getHost();
            int port = this.uri.getPort();
            if (!VALID_PROTOCOLS.contains(scheme) || host == null || port == -1) {
                throw new IllegalArgumentException(String.format("Master endpoints must be of the form \"%s://<hostname>:<port>\"", VALID_PROTOCOLS_STR));
            }
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public InetAddress getIp() {
            return this.ip;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultEndpoint that = (DefaultEndpoint)o;
            if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
                return false;
            }
            return !(this.uri == null ? that.uri != null : !this.uri.equals(that.uri));
        }

        public int hashCode() {
            int result = this.ip != null ? this.ip.hashCode() : 0;
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DefaultEndpoint{ip=" + this.ip + ", uri=" + this.uri + '}';
        }
    }
}

