/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.spotify.helios.client.shaded.com.spotify.dns.AbstractChangeNotifier;
import com.spotify.helios.client.shaded.com.spotify.dns.ChangeNotifier;
import com.spotify.helios.client.shaded.com.spotify.dns.ChangeNotifierFactory;
import java.util.Set;

class DirectChangeNotifier<T>
extends AbstractChangeNotifier<T>
implements ChangeNotifierFactory.RunnableChangeNotifier<T> {
    private final Supplier<Set<T>> recordsSupplier;
    private volatile Set<T> records = ImmutableSet.of();
    private volatile boolean run = true;

    public DirectChangeNotifier(Supplier<Set<T>> recordsSupplier) {
        this.recordsSupplier = (Supplier)Preconditions.checkNotNull(recordsSupplier, (Object)"recordsSupplier");
    }

    @Override
    protected void closeImplementation() {
        this.run = false;
    }

    @Override
    public Set<T> current() {
        return this.records;
    }

    @Override
    public void run() {
        if (!this.run) {
            return;
        }
        Set current = (Set)this.recordsSupplier.get();
        if (!current.equals(this.records)) {
            ChangeNotifier.ChangeNotification<T> changeNotification = this.newChangeNotification(current, this.records);
            this.records = current;
            this.fireRecordsUpdated(changeNotification);
        }
    }
}

