/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.tls;

import com.google.common.base.Throwables;
import com.spotify.sshagentproxy.AgentProxy;
import com.spotify.sshagentproxy.Identity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

class SshAgentContentSigner
implements ContentSigner {
    private static final AlgorithmIdentifier IDENTIFIER = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final AgentProxy agentProxy;
    private final Identity identity;

    public SshAgentContentSigner(AgentProxy agentProxy, Identity identity) {
        this.agentProxy = agentProxy;
        this.identity = identity;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return IDENTIFIER;
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public byte[] getSignature() {
        try {
            return this.agentProxy.sign(this.identity, this.stream.toByteArray());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

