/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.context;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.spotify.helios.common.context.Context;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ContextListeningExecutorService
implements ListeningExecutorService {
    private final ListeningExecutorService service;

    ContextListeningExecutorService(ListeningExecutorService service) {
        this.service = service;
    }

    public void shutdown() {
        this.service.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.service.shutdownNow();
    }

    public boolean isShutdown() {
        return this.service.isShutdown();
    }

    public boolean isTerminated() {
        return this.service.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.service.awaitTermination(timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.service.invokeAny(Context.makeContextWrappedCollection(tasks));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.service.invokeAny(Context.makeContextWrappedCollection(tasks), timeout, unit);
    }

    public void execute(Runnable command) {
        this.service.execute(Context.makeContextRunnable(command));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.service.invokeAll(Context.makeContextWrappedCollection(tasks));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.service.invokeAll(Context.makeContextWrappedCollection(tasks), timeout, unit);
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.service.submit(Context.makeContextCallable(task));
    }

    public ListenableFuture<?> submit(Runnable command) {
        return this.service.submit(Context.makeContextRunnable(command));
    }

    public <T> ListenableFuture<T> submit(Runnable command, T result) {
        return this.service.submit(Context.makeContextRunnable(command), result);
    }
}

