/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.spotify.helios.common.Hash;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.HealthCheck;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.Resources;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Job
extends Descriptor
implements Comparable<Job> {
    public static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    public static final Resources EMPTY_RESOURCES = null;
    public static final Map<String, PortMapping> EMPTY_PORTS = Collections.emptyMap();
    public static final Long EMPTY_CREATED = null;
    public static final List<String> EMPTY_COMMAND = Collections.emptyList();
    public static final Map<ServiceEndpoint, ServicePorts> EMPTY_REGISTRATION = Collections.emptyMap();
    public static final Integer EMPTY_GRACE_PERIOD = null;
    public static final Map<String, String> EMPTY_VOLUMES = Collections.emptyMap();
    public static final String EMPTY_MOUNT = "";
    public static final Date EMPTY_EXPIRES = null;
    public static final String EMPTY_REGISTRATION_DOMAIN = "";
    public static final String EMPTY_CREATING_USER = null;
    public static final String EMPTY_TOKEN = "";
    public static final HealthCheck EMPTY_HEALTH_CHECK = null;
    public static final List<String> EMPTY_SECURITY_OPT = Collections.emptyList();
    public static final String DEFAULT_NETWORK_MODE = "bridge";
    public static final String EMPTY_HOSTNAME = null;
    public static final Map<String, String> EMPTY_METADATA = Collections.emptyMap();
    public static final Set<String> EMPTY_CAPS = Collections.emptySet();
    public static final Integer EMPTY_SECONDS_TO_WAIT = null;
    private final JobId id;
    private final String image;
    private final String hostname;
    private final Long created;
    private final List<String> command;
    private final Map<String, String> env;
    private final Resources resources;
    private final Map<String, PortMapping> ports;
    private final Map<ServiceEndpoint, ServicePorts> registration;
    private final Integer gracePeriod;
    private final Map<String, String> volumes;
    private final Date expires;
    private final String registrationDomain;
    private final String creatingUser;
    private final String token;
    private final HealthCheck healthCheck;
    private final List<String> securityOpt;
    private final String networkMode;
    private final Map<String, String> metadata;
    private final Set<String> addCapabilities;
    private final Set<String> dropCapabilities;
    private final Integer secondsToWaitBeforeKill;

    public Job(@JsonProperty(value="id") JobId id, @JsonProperty(value="image") String image, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="created") @Nullable Long created, @JsonProperty(value="command") @Nullable List<String> command, @JsonProperty(value="env") @Nullable Map<String, String> env, @JsonProperty(value="resources") @Nullable Resources resources, @JsonProperty(value="ports") @Nullable Map<String, PortMapping> ports, @JsonProperty(value="registration") @Nullable Map<ServiceEndpoint, ServicePorts> registration, @JsonProperty(value="gracePeriod") @Nullable Integer gracePeriod, @JsonProperty(value="volumes") @Nullable Map<String, String> volumes, @JsonProperty(value="expires") @Nullable Date expires, @JsonProperty(value="registrationDomain") @Nullable String registrationDomain, @JsonProperty(value="creatingUser") @Nullable String creatingUser, @JsonProperty(value="token") @Nullable String token, @JsonProperty(value="healthCheck") @Nullable HealthCheck healthCheck, @JsonProperty(value="securityOpt") @Nullable List<String> securityOpt, @JsonProperty(value="networkMode") @Nullable String networkMode, @JsonProperty(value="metadata") @Nullable Map<String, String> metadata, @JsonProperty(value="addCapabilities") @Nullable Set<String> addCapabilities, @JsonProperty(value="dropCapabilities") @Nullable Set<String> dropCapabilities, @JsonProperty(value="secondsToWaitBeforeKill") @Nullable Integer secondsToWaitBeforeKill) {
        this.id = id;
        this.image = image;
        this.hostname = (String)Optional.fromNullable((Object)hostname).orNull();
        this.created = (Long)Optional.fromNullable((Object)created).orNull();
        this.command = (List)Optional.fromNullable(command).or(EMPTY_COMMAND);
        this.env = (Map)Optional.fromNullable(env).or(EMPTY_ENV);
        this.resources = (Resources)Optional.fromNullable((Object)resources).orNull();
        this.ports = (Map)Optional.fromNullable(ports).or(EMPTY_PORTS);
        this.registration = (Map)Optional.fromNullable(registration).or(EMPTY_REGISTRATION);
        this.gracePeriod = (Integer)Optional.fromNullable((Object)gracePeriod).orNull();
        this.volumes = (Map)Optional.fromNullable(volumes).or(EMPTY_VOLUMES);
        this.expires = expires;
        this.registrationDomain = (String)Optional.fromNullable((Object)registrationDomain).or((Object)"");
        this.creatingUser = (String)Optional.fromNullable((Object)creatingUser).orNull();
        this.token = (String)Optional.fromNullable((Object)token).or((Object)"");
        this.healthCheck = (HealthCheck)Optional.fromNullable((Object)healthCheck).orNull();
        this.securityOpt = (List)Optional.fromNullable(securityOpt).or(EMPTY_SECURITY_OPT);
        this.networkMode = (String)Optional.fromNullable((Object)networkMode).orNull();
        this.metadata = (Map)Optional.fromNullable(metadata).or(EMPTY_METADATA);
        this.addCapabilities = (Set)MoreObjects.firstNonNull(addCapabilities, EMPTY_CAPS);
        this.dropCapabilities = (Set)MoreObjects.firstNonNull(dropCapabilities, EMPTY_CAPS);
        this.secondsToWaitBeforeKill = secondsToWaitBeforeKill;
    }

    private Job(JobId id, Builder.Parameters p) {
        this.id = id;
        this.image = p.image;
        this.hostname = p.hostname;
        this.created = p.created;
        this.command = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(p.command, (Object)"command")));
        this.env = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.env, (Object)"env")));
        this.resources = p.resources;
        this.ports = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.ports, (Object)"ports")));
        this.registration = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.registration, (Object)"registration")));
        this.gracePeriod = p.gracePeriod;
        this.volumes = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.volumes, (Object)"volumes")));
        this.expires = p.expires;
        this.registrationDomain = (String)Optional.fromNullable((Object)p.registrationDomain).or((Object)"");
        this.creatingUser = p.creatingUser;
        this.token = p.token;
        this.healthCheck = p.healthCheck;
        this.securityOpt = p.securityOpt;
        this.networkMode = p.networkMode;
        this.metadata = ImmutableMap.copyOf(p.metadata);
        this.addCapabilities = ImmutableSet.copyOf(p.addCapabilities);
        this.dropCapabilities = ImmutableSet.copyOf(p.dropCapabilities);
        this.secondsToWaitBeforeKill = p.secondsToWaitBeforeKill;
    }

    public JobId getId() {
        return this.id;
    }

    public String getImage() {
        return this.image;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Long getCreated() {
        return this.created;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Map<String, PortMapping> getPorts() {
        return this.ports;
    }

    public Map<ServiceEndpoint, ServicePorts> getRegistration() {
        return this.registration;
    }

    public String getRegistrationDomain() {
        return this.registrationDomain;
    }

    public Integer getGracePeriod() {
        return this.gracePeriod;
    }

    public Map<String, String> getVolumes() {
        return this.volumes;
    }

    public Date getExpires() {
        return this.expires;
    }

    public String getCreatingUser() {
        return this.creatingUser;
    }

    public String getToken() {
        return this.token;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public List<String> getSecurityOpt() {
        return this.securityOpt;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Set<String> getAddCapabilities() {
        return this.addCapabilities;
    }

    public Set<String> getDropCapabilities() {
        return this.dropCapabilities;
    }

    public Integer getSecondsToWaitBeforeKill() {
        return this.secondsToWaitBeforeKill;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public int compareTo(@NotNull Job o) {
        return this.id.compareTo(o.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job that = (Job)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.image, that.image) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.expires, that.expires) && Objects.equals(this.created, that.created) && Objects.equals(this.command, that.command) && Objects.equals(this.env, that.env) && Objects.equals(this.resources, that.resources) && Objects.equals(this.ports, that.ports) && Objects.equals(this.registration, that.registration) && Objects.equals(this.registrationDomain, that.registrationDomain) && Objects.equals(this.gracePeriod, that.gracePeriod) && Objects.equals(this.volumes, that.volumes) && Objects.equals(this.creatingUser, that.creatingUser) && Objects.equals(this.token, that.token) && Objects.equals(this.healthCheck, that.healthCheck) && Objects.equals(this.securityOpt, that.securityOpt) && Objects.equals(this.networkMode, that.networkMode) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.addCapabilities, that.addCapabilities) && Objects.equals(this.dropCapabilities, that.dropCapabilities) && Objects.equals(this.secondsToWaitBeforeKill, that.secondsToWaitBeforeKill);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.image, this.hostname, this.expires, this.created, this.command, this.env, this.resources, this.ports, this.registration, this.registrationDomain, this.gracePeriod, this.volumes, this.creatingUser, this.token, this.healthCheck, this.securityOpt, this.networkMode, this.metadata, this.addCapabilities, this.dropCapabilities, this.secondsToWaitBeforeKill);
    }

    public String toString() {
        return "Job{id=" + this.id + ", image='" + this.image + '\'' + ", hostname='" + this.hostname + '\'' + ", created=" + this.created + ", command=" + this.command + ", env=" + this.env + ", resources=" + this.resources + ", ports=" + this.ports + ", registration=" + this.registration + ", gracePeriod=" + this.gracePeriod + ", volumes=" + this.volumes + ", expires=" + this.expires + ", registrationDomain='" + this.registrationDomain + '\'' + ", creatingUser='" + this.creatingUser + '\'' + ", token='" + this.token + '\'' + ", healthCheck=" + this.healthCheck + ", securityOpt=" + this.securityOpt + ", networkMode='" + this.networkMode + '\'' + ", metadata=" + this.metadata + ", addCapabilities=" + this.addCapabilities + ", dropCapabilities=" + this.dropCapabilities + ", secondsToWaitBeforeKill=" + this.secondsToWaitBeforeKill + "} " + super.toString();
    }

    public Builder toBuilder() {
        Builder builder = Job.newBuilder();
        if (this.id != null) {
            builder.setName(this.id.getName()).setVersion(this.id.getVersion());
        }
        return builder.setImage(this.image).setHostname(this.hostname).setCreated(this.created).setCommand(this.command).setEnv(this.env).setResources(this.resources).setPorts(this.ports).setRegistration(this.registration).setGracePeriod(this.gracePeriod).setVolumes(this.volumes).setExpires(this.expires).setRegistrationDomain(this.registrationDomain).setCreatingUser(this.creatingUser).setToken(this.token).setHealthCheck(this.healthCheck).setSecurityOpt(this.securityOpt).setNetworkMode(this.networkMode).setMetadata(this.metadata).setAddCapabilities(this.addCapabilities).setDropCapabilities(this.dropCapabilities).setSecondsToWaitBeforeKill(this.secondsToWaitBeforeKill);
    }

    public static class Builder
    implements Cloneable {
        private final Parameters p;
        private String hash;

        private Builder() {
            this.p = new Parameters();
        }

        public Builder(String hash, Parameters parameters) {
            this.hash = hash;
            this.p = parameters;
        }

        public Builder setRegistrationDomain(String domain) {
            this.p.registrationDomain = domain;
            return this;
        }

        public Builder setCreatingUser(String creatingUser) {
            this.p.creatingUser = creatingUser;
            return this;
        }

        public Builder setToken(String token) {
            this.p.token = token;
            return this;
        }

        public Builder setHash(String hash) {
            this.hash = hash;
            return this;
        }

        public Builder setName(String name) {
            this.p.name = name;
            return this;
        }

        public Builder setVersion(String version) {
            this.p.version = version;
            return this;
        }

        public Builder setImage(String image) {
            this.p.image = image;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.p.hostname = hostname;
            return this;
        }

        public Builder setCreated(Long created) {
            this.p.created = created;
            return this;
        }

        public Builder setCommand(List<String> command) {
            this.p.command = ImmutableList.copyOf(command);
            return this;
        }

        public Builder setEnv(Map<String, String> env) {
            this.p.env = Maps.newHashMap(env);
            return this;
        }

        public Builder setResources(Resources resources) {
            this.p.resources = resources;
            return this;
        }

        public Builder addEnv(String key, String value) {
            this.p.env.put(key, value);
            return this;
        }

        public Builder setPorts(Map<String, PortMapping> ports) {
            this.p.ports = Maps.newHashMap(ports);
            return this;
        }

        public Builder addPort(String name, PortMapping port) {
            this.p.ports.put(name, port);
            return this;
        }

        public Builder setRegistration(Map<ServiceEndpoint, ServicePorts> registration) {
            this.p.registration = Maps.newHashMap(registration);
            return this;
        }

        public Builder addRegistration(ServiceEndpoint endpoint, ServicePorts ports) {
            this.p.registration.put(endpoint, ports);
            return this;
        }

        public Builder setGracePeriod(Integer gracePeriod) {
            this.p.gracePeriod = gracePeriod;
            return this;
        }

        public Builder setVolumes(Map<String, String> volumes) {
            this.p.volumes = Maps.newHashMap(volumes);
            return this;
        }

        public Builder addVolume(String path) {
            this.p.volumes.put(path, "");
            return this;
        }

        public Builder addVolume(String path, String source) {
            this.p.volumes.put(path, source);
            return this;
        }

        public Builder setExpires(Date expires) {
            this.p.expires = expires;
            return this;
        }

        public Builder setHealthCheck(HealthCheck healthCheck) {
            this.p.healthCheck = healthCheck;
            return this;
        }

        public Builder setSecurityOpt(List<String> securityOpt) {
            this.p.securityOpt = ImmutableList.copyOf(securityOpt);
            return this;
        }

        public Builder setNetworkMode(String networkMode) {
            this.p.networkMode = networkMode;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.p.metadata = Maps.newHashMap(metadata);
            return this;
        }

        public Builder addMetadata(String name, String value) {
            this.p.metadata.put(name, value);
            return this;
        }

        public Builder setAddCapabilities(Collection<String> addCapabilities) {
            this.p.addCapabilities = ImmutableSet.copyOf(addCapabilities);
            return this;
        }

        public Builder setDropCapabilities(Collection<String> dropCapabilities) {
            this.p.dropCapabilities = ImmutableSet.copyOf(dropCapabilities);
            return this;
        }

        public Builder setSecondsToWaitBeforeKill(Integer secondsToWaitBeforeKill) {
            this.p.secondsToWaitBeforeKill = secondsToWaitBeforeKill;
            return this;
        }

        public String getName() {
            return this.p.name;
        }

        public String getVersion() {
            return this.p.version;
        }

        public String getImage() {
            return this.p.image;
        }

        public String getHostname() {
            return this.p.hostname;
        }

        public List<String> getCommand() {
            return this.p.command;
        }

        public Map<String, String> getEnv() {
            return ImmutableMap.copyOf(this.p.env);
        }

        public Map<String, PortMapping> getPorts() {
            return ImmutableMap.copyOf(this.p.ports);
        }

        public Map<ServiceEndpoint, ServicePorts> getRegistration() {
            return ImmutableMap.copyOf(this.p.registration);
        }

        public String getRegistrationDomain() {
            return this.p.registrationDomain;
        }

        public Integer getGracePeriod() {
            return this.p.gracePeriod;
        }

        public Map<String, String> getVolumes() {
            return ImmutableMap.copyOf(this.p.volumes);
        }

        public Date getExpires() {
            return this.p.expires;
        }

        public String getCreatingUser() {
            return this.p.creatingUser;
        }

        public Resources getResources() {
            return this.p.resources;
        }

        public HealthCheck getHealthCheck() {
            return this.p.healthCheck;
        }

        public List<String> getSecurityOpt() {
            return this.p.securityOpt;
        }

        public String getNetworkMode() {
            return this.p.networkMode;
        }

        public Map<String, String> getMetadata() {
            return ImmutableMap.copyOf(this.p.metadata);
        }

        public Set<String> getAddCapabilities() {
            return this.p.addCapabilities;
        }

        public Set<String> getDropCapabilities() {
            return this.p.dropCapabilities;
        }

        public Integer secondsToWaitBeforeKill() {
            return this.p.secondsToWaitBeforeKill;
        }

        public Builder clone() {
            return new Builder(this.hash, new Parameters(this.p));
        }

        public Job build() {
            String hash;
            String configHash;
            try {
                configHash = this.hex(Json.sha1digest(this.p.withoutMetaParameters()));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            if (!Strings.isNullOrEmpty((String)this.hash)) {
                hash = this.hash;
            } else if (this.p.name != null && this.p.version != null) {
                String input = String.format("%s:%s:%s", this.p.name, this.p.version, configHash);
                hash = this.hex(Hash.sha1digest(input.getBytes(Charsets.UTF_8)));
            } else {
                hash = null;
            }
            JobId id = new JobId(this.p.name, this.p.version, hash);
            return new Job(id, this.p);
        }

        public Job buildWithoutHash() {
            JobId id = new JobId(this.p.name, this.p.version);
            return new Job(id, this.p);
        }

        private String hex(byte[] bytes) {
            return BaseEncoding.base16().lowerCase().encode(bytes);
        }

        private static class Parameters
        implements Cloneable {
            public String registrationDomain;
            public String name;
            public String version;
            public String image;
            public String hostname;
            public Long created;
            public List<String> command;
            public Map<String, String> env;
            public Resources resources;
            public Map<String, PortMapping> ports;
            public Map<ServiceEndpoint, ServicePorts> registration;
            public Integer gracePeriod;
            public Map<String, String> volumes;
            public Date expires;
            public String creatingUser;
            public String token;
            public HealthCheck healthCheck;
            public List<String> securityOpt;
            public String networkMode;
            public Map<String, String> metadata;
            public Set<String> addCapabilities;
            public Set<String> dropCapabilities;
            public Integer secondsToWaitBeforeKill;

            private Parameters() {
                this.created = EMPTY_CREATED;
                this.command = EMPTY_COMMAND;
                this.env = Maps.newHashMap(EMPTY_ENV);
                this.resources = EMPTY_RESOURCES;
                this.ports = Maps.newHashMap(EMPTY_PORTS);
                this.registration = Maps.newHashMap(EMPTY_REGISTRATION);
                this.gracePeriod = EMPTY_GRACE_PERIOD;
                this.volumes = Maps.newHashMap(EMPTY_VOLUMES);
                this.registrationDomain = "";
                this.creatingUser = EMPTY_CREATING_USER;
                this.token = "";
                this.healthCheck = EMPTY_HEALTH_CHECK;
                this.securityOpt = EMPTY_SECURITY_OPT;
                this.metadata = Maps.newHashMap();
                this.addCapabilities = EMPTY_CAPS;
                this.dropCapabilities = EMPTY_CAPS;
            }

            private Parameters(Parameters p) {
                this.name = p.name;
                this.version = p.version;
                this.image = p.image;
                this.hostname = p.hostname;
                this.created = p.created;
                this.command = ImmutableList.copyOf(p.command);
                this.env = Maps.newHashMap(p.env);
                this.resources = p.resources;
                this.ports = Maps.newHashMap(p.ports);
                this.registration = Maps.newHashMap(p.registration);
                this.gracePeriod = p.gracePeriod;
                this.volumes = Maps.newHashMap(p.volumes);
                this.expires = p.expires;
                this.registrationDomain = p.registrationDomain;
                this.creatingUser = p.creatingUser;
                this.token = p.token;
                this.healthCheck = p.healthCheck;
                this.securityOpt = p.securityOpt;
                this.networkMode = p.networkMode;
                this.metadata = p.metadata;
                this.addCapabilities = p.addCapabilities;
                this.dropCapabilities = p.dropCapabilities;
                this.secondsToWaitBeforeKill = p.secondsToWaitBeforeKill;
            }

            private Parameters withoutMetaParameters() {
                Parameters clone = new Parameters(this);
                clone.creatingUser = null;
                clone.created = null;
                return clone;
            }
        }
    }
}

