/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.spotify.helios.common.descriptors.HealthCheck;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TcpHealthCheck
extends HealthCheck {
    private final String port;

    public TcpHealthCheck(@JsonProperty(value="port") String port) {
        super("tcp");
        this.port = port;
    }

    private TcpHealthCheck(Builder builder) {
        super("tcp");
        this.port = builder.port;
    }

    public String getPort() {
        return this.port;
    }

    public static TcpHealthCheck of(String port) {
        return TcpHealthCheck.newBuilder().setPort(port).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpHealthCheck that = (TcpHealthCheck)o;
        return !(this.port != null ? !this.port.equals(that.port) : that.port != null);
    }

    public int hashCode() {
        return this.port != null ? this.port.hashCode() : 0;
    }

    public String toString() {
        return "TcpHealthCheck{port='" + this.port + '\'' + "} " + super.toString();
    }

    static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String port;

        public String getPort() {
            return this.port;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public TcpHealthCheck build() {
            if (Strings.isNullOrEmpty((String)this.port)) {
                throw new IllegalArgumentException("You must specify the name of a port you opened to the container for a TCP health check.");
            }
            return new TcpHealthCheck(this);
        }
    }
}

