/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.tls;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class CertificateAndPrivateKey {
    private final Certificate certificate;
    private final PrivateKey privateKey;

    public CertificateAndPrivateKey(Certificate certificate, PrivateKey privateKey) {
        Preconditions.checkNotNull((Object)certificate, (Object)"certificate");
        Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey");
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public static CertificateAndPrivateKey from(Path certPath, Path keyPath) throws IOException, GeneralSecurityException {
        PrivateKeyInfo keyInfo;
        Object parsedPem;
        Certificate certificate;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream is = Files.newInputStream(certPath, new OpenOption[0]);){
            certificate = cf.generateCertificate(is);
        }
        try (BufferedReader br = Files.newBufferedReader(keyPath, Charset.defaultCharset());){
            parsedPem = new PEMParser((Reader)br).readObject();
        }
        if (parsedPem instanceof PEMKeyPair) {
            keyInfo = ((PEMKeyPair)parsedPem).getPrivateKeyInfo();
        } else if (parsedPem instanceof PrivateKeyInfo) {
            keyInfo = (PrivateKeyInfo)parsedPem;
        } else {
            throw new UnsupportedOperationException("Unable to parse x509 certificate.");
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyInfo.getEncoded());
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return new CertificateAndPrivateKey(certificate, kf.generatePrivate(spec));
    }
}

