/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.client.ClientCertificatePath;
import com.spotify.helios.client.DefaultHttpConnector;
import com.spotify.helios.client.Endpoint;
import com.spotify.helios.client.EndpointIterator;
import com.spotify.helios.client.HttpConnector;
import com.spotify.helios.client.HttpsHandlers;
import com.spotify.helios.common.HeliosException;
import com.spotify.sshagentproxy.AgentProxy;
import com.spotify.sshagentproxy.Identity;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatingHttpConnector
implements HttpConnector {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatingHttpConnector.class);
    private final String user;
    private final Optional<AgentProxy> agentProxy;
    private final Optional<ClientCertificatePath> clientCertificatePath;
    private final List<Identity> identities;
    private final EndpointIterator endpointIterator;
    private final DefaultHttpConnector delegate;

    public AuthenticatingHttpConnector(String user, Optional<AgentProxy> agentProxyOpt, Optional<ClientCertificatePath> clientCertificatePath, EndpointIterator endpointIterator, DefaultHttpConnector delegate) {
        this(user, agentProxyOpt, clientCertificatePath, endpointIterator, delegate, AuthenticatingHttpConnector.getSshIdentities(agentProxyOpt));
    }

    @VisibleForTesting
    AuthenticatingHttpConnector(String user, Optional<AgentProxy> agentProxyOpt, Optional<ClientCertificatePath> clientCertificatePath, EndpointIterator endpointIterator, DefaultHttpConnector delegate, List<Identity> identities) {
        this.user = user;
        this.agentProxy = agentProxyOpt;
        this.clientCertificatePath = clientCertificatePath;
        this.endpointIterator = endpointIterator;
        this.delegate = delegate;
        this.identities = identities;
    }

    @Override
    public HttpURLConnection connect(URI uri, String method, byte[] entity, Map<String, List<String>> headers) throws HeliosException {
        URI ipUri;
        Endpoint endpoint = this.endpointIterator.next();
        try {
            ipUri = this.toIpUri(endpoint, uri);
        }
        catch (URISyntaxException e) {
            throw new HeliosException(e);
        }
        try {
            log.debug("connecting to {}", (Object)ipUri);
            if (this.clientCertificatePath.isPresent()) {
                return this.connectWithCertificateFile(ipUri, method, entity, headers);
            }
            if (this.agentProxy.isPresent() && !this.identities.isEmpty()) {
                return this.connectWithIdentities(this.identities, ipUri, method, entity, headers);
            }
            return this.doConnect(ipUri, method, entity, headers);
        }
        catch (ConnectException | SocketTimeoutException | UnknownHostException e) {
            log.debug(e.toString());
            throw new HeliosException("Unable to connect to master: " + ipUri, e);
        }
        catch (IOException e) {
            throw new HeliosException("Unexpected error connecting to " + ipUri, e);
        }
    }

    private HttpURLConnection connectWithCertificateFile(URI ipUri, String method, byte[] entity, Map<String, List<String>> headers) throws HeliosException {
        ClientCertificatePath clientCertificatePath = (ClientCertificatePath)this.clientCertificatePath.get();
        log.debug("configuring CertificateFileHttpsHandler with {}", (Object)clientCertificatePath);
        this.delegate.setExtraHttpsHandler(new HttpsHandlers.CertificateFileHttpsHandler(this.user, false, clientCertificatePath));
        return this.doConnect(ipUri, method, entity, headers);
    }

    private HttpURLConnection connectWithIdentities(List<Identity> identities, URI uri, String method, byte[] entity, Map<String, List<String>> headers) throws IOException, HeliosException {
        if (identities.isEmpty()) {
            throw new IllegalArgumentException("identities cannot be empty");
        }
        LinkedList<Identity> queue = new LinkedList<Identity>(identities);
        HttpURLConnection connection = null;
        while (!queue.isEmpty()) {
            boolean retryResponse;
            Identity identity = (Identity)queue.poll();
            this.delegate.setExtraHttpsHandler(new HttpsHandlers.SshAgentHttpsHandler(this.user, false, (AgentProxy)this.agentProxy.get(), identity));
            connection = this.doConnect(uri, method, entity, headers);
            int responseCode = connection.getResponseCode();
            boolean bl = retryResponse = responseCode == 403 || responseCode == 401;
            if (!retryResponse || queue.isEmpty()) break;
            log.debug("retrying with next SSH identity since {} failed", (Object)(identity == null ? "the previous one" : identity.getComment()));
        }
        return connection;
    }

    private HttpURLConnection doConnect(URI uri, String method, byte[] entity, Map<String, List<String>> headers) throws HeliosException {
        return this.delegate.connect(uri, method, entity, headers);
    }

    private URI toIpUri(Endpoint endpoint, URI uri) throws URISyntaxException {
        URI endpointUri = endpoint.getUri();
        String fullpath = endpointUri.getPath() + uri.getPath();
        return new URI(endpointUri.getScheme(), endpointUri.getUserInfo(), endpoint.getIp().getHostAddress(), endpointUri.getPort(), fullpath, uri.getQuery(), null);
    }

    private static List<Identity> getSshIdentities(Optional<AgentProxy> agentProxyOpt) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        if (agentProxyOpt.isPresent()) {
            try {
                List identities = ((AgentProxy)agentProxyOpt.get()).list();
                for (Identity identity : identities) {
                    if (!identity.getPublicKey().getAlgorithm().equals("RSA")) continue;
                    listBuilder.add((Object)identity);
                }
            }
            catch (Exception e) {
                log.debug("Unable to get identities from ssh-agent. Note that this might not indicate an actual problem unless your Helios cluster requires authentication for all requests.", (Throwable)e);
            }
        }
        return listBuilder.build();
    }

    @Override
    public void close() throws IOException {
        if (this.agentProxy.isPresent()) {
            ((AgentProxy)this.agentProxy.get()).close();
        }
    }
}

