/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.spotify.helios.client.Endpoint;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.annotation.Nullable;

class EndpointIterator
implements Iterator<Endpoint> {
    private final List<Endpoint> endpoints;
    private final int size;
    private int cursor;

    private EndpointIterator(List<Endpoint> endpoints) {
        this.endpoints = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(endpoints)));
        this.size = this.endpoints.size();
        this.cursor = this.size == 0 ? 0 : new Random().nextInt(this.size);
    }

    static EndpointIterator of(List<Endpoint> endpoints) {
        return new EndpointIterator(endpoints);
    }

    @Override
    public boolean hasNext() {
        return this.size > 0;
    }

    @Override
    public Endpoint next() {
        Endpoint endpoint;
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        if (this.cursor < this.size) {
            endpoint = this.endpoints.get(this.cursor++);
        } else {
            this.cursor = 0;
            endpoint = this.endpoints.get(0);
        }
        return endpoint;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    boolean hasHttps() {
        return Iterables.any(this.endpoints, (Predicate)new Predicate<Endpoint>(){

            public boolean apply(@Nullable Endpoint endpoint) {
                return endpoint != null && endpoint.getUri() != null && endpoint.getUri().getScheme() != null && endpoint.getUri().getScheme().equalsIgnoreCase("https");
            }
        });
    }
}

