/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HostnameVerifierProvider {
    private static final Logger log = LoggerFactory.getLogger(HostnameVerifierProvider.class);
    private final boolean hostnameVerificationEnabled;
    private final HostnameVerifier delegate;

    public HostnameVerifierProvider(boolean hostnameVerificationEnabled, HostnameVerifier delegate) {
        this.hostnameVerificationEnabled = hostnameVerificationEnabled;
        this.delegate = delegate;
    }

    public HostnameVerifier verifierFor(String hostname) {
        if (!this.hostnameVerificationEnabled) {
            log.debug("hostname verification disabled");
            return new HostnameVerifier(){

                @Override
                public boolean verify(String str, SSLSession sslSession) {
                    return true;
                }
            };
        }
        final String tHostname = hostname.endsWith(".") ? hostname.substring(0, hostname.length() - 1) : hostname;
        log.debug("configuring DefaultHostnameVerifier to expect hostname={}", (Object)tHostname);
        return new HostnameVerifier(){

            @Override
            public boolean verify(String str, SSLSession sslSession) {
                return HostnameVerifierProvider.this.delegate.verify(tHostname, sslSession);
            }
        };
    }
}

