/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.spotify.helios.client.shaded.com.spotify.dns.DnsException;
import com.spotify.helios.client.shaded.com.spotify.dns.LookupFactory;
import com.spotify.helios.client.shaded.org.xbill.DNS.Lookup;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class CachingLookupFactory
implements LookupFactory {
    private final LookupFactory delegate;
    private final ThreadLocal<Cache<String, Lookup>> cacheHolder;

    CachingLookupFactory(LookupFactory delegate) {
        this.delegate = (LookupFactory)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.cacheHolder = new ThreadLocal<Cache<String, Lookup>>(){

            @Override
            protected Cache<String, Lookup> initialValue() {
                return CacheBuilder.newBuilder().build();
            }
        };
    }

    @Override
    public Lookup forName(final String fqdn) {
        try {
            return (Lookup)this.cacheHolder.get().get((Object)fqdn, (Callable)new Callable<Lookup>(){

                @Override
                public Lookup call() {
                    return CachingLookupFactory.this.delegate.forName(fqdn);
                }
            });
        }
        catch (ExecutionException e) {
            throw new DnsException(e);
        }
    }
}

