/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.client.shaded.com.spotify.dns.DnsException;
import com.spotify.helios.client.shaded.com.spotify.dns.DnsSrvResolver;
import com.spotify.helios.client.shaded.com.spotify.dns.LookupFactory;
import com.spotify.helios.client.shaded.com.spotify.dns.LookupResult;
import com.spotify.helios.client.shaded.org.xbill.DNS.Lookup;
import com.spotify.helios.client.shaded.org.xbill.DNS.Record;
import com.spotify.helios.client.shaded.org.xbill.DNS.SRVRecord;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XBillDnsSrvResolver
implements DnsSrvResolver {
    private static final Logger LOG = LoggerFactory.getLogger(XBillDnsSrvResolver.class);
    private final LookupFactory lookupFactory;

    XBillDnsSrvResolver(LookupFactory lookupFactory) {
        this.lookupFactory = (LookupFactory)Preconditions.checkNotNull((Object)lookupFactory, (Object)"lookupFactory");
    }

    @Override
    public List<LookupResult> resolve(String fqdn) {
        Lookup lookup = this.lookupFactory.forName(fqdn);
        Record[] queryResult = lookup.run();
        switch (lookup.getResult()) {
            case 0: {
                return XBillDnsSrvResolver.toLookupResults(queryResult);
            }
            case 3: 
            case 4: {
                LOG.warn("No results returned for query '{}'; result from XBill: {} - {}", new Object[]{fqdn, lookup.getResult(), lookup.getErrorString()});
                return ImmutableList.of();
            }
        }
        throw new DnsException(String.format("Lookup of '%s' failed with code: %d - %s ", fqdn, lookup.getResult(), lookup.getErrorString()));
    }

    private static List<LookupResult> toLookupResults(Record[] queryResult) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (queryResult != null) {
            for (Record record : queryResult) {
                if (!(record instanceof SRVRecord)) continue;
                SRVRecord srvRecord = (SRVRecord)record;
                builder.add((Object)LookupResult.create(srvRecord.getTarget().toString(), srvRecord.getPort(), srvRecord.getPriority(), srvRecord.getWeight(), srvRecord.getTTL()));
            }
        }
        return builder.build();
    }
}

