/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.org.xbill.DNS;

import com.spotify.helios.client.shaded.org.xbill.DNS.Compression;
import com.spotify.helios.client.shaded.org.xbill.DNS.DNSInput;
import com.spotify.helios.client.shaded.org.xbill.DNS.DNSOutput;
import com.spotify.helios.client.shaded.org.xbill.DNS.Name;
import com.spotify.helios.client.shaded.org.xbill.DNS.Record;
import com.spotify.helios.client.shaded.org.xbill.DNS.Tokenizer;
import com.spotify.helios.client.shaded.org.xbill.DNS.utils.base64;
import java.io.IOException;

public class DHCIDRecord
extends Record {
    private static final long serialVersionUID = -8214820200808997707L;
    private byte[] data;

    DHCIDRecord() {
    }

    Record getObject() {
        return new DHCIDRecord();
    }

    public DHCIDRecord(Name name, int dclass, long ttl, byte[] data) {
        super(name, 49, dclass, ttl);
        this.data = data;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.data = in.readByteArray();
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.data = st.getBase64();
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }

    String rrToString() {
        return base64.toString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }
}

