/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.helios.common.descriptors.Descriptor;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AgentInfo
extends Descriptor {
    private final String name;
    private final String vmName;
    private final String vmVendor;
    private final String vmVersion;
    private final String specName;
    private final String specVendor;
    private final String specVersion;
    private final List<String> inputArguments;
    private final long uptime;
    private final long startTime;
    private final String version;

    public AgentInfo(@JsonProperty(value="name") String name, @JsonProperty(value="vmName") String vmName, @JsonProperty(value="vmVendor") String vmVendor, @JsonProperty(value="vmVersion") String vmVersion, @JsonProperty(value="specName") String specName, @JsonProperty(value="specVendor") String specVendor, @JsonProperty(value="specVersion") String specVersion, @JsonProperty(value="inputArguments") List<String> inputArguments, @JsonProperty(value="uptime") long uptime, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="version") String version) {
        this.name = name;
        this.vmName = vmName;
        this.vmVendor = vmVendor;
        this.vmVersion = vmVersion;
        this.specName = specName;
        this.specVendor = specVendor;
        this.specVersion = specVersion;
        this.inputArguments = inputArguments;
        this.uptime = uptime;
        this.startTime = startTime;
        this.version = version;
    }

    public AgentInfo(Builder builder) {
        this.name = builder.name;
        this.vmName = builder.vmName;
        this.vmVendor = builder.vmVendor;
        this.vmVersion = builder.vmVersion;
        this.specName = builder.specName;
        this.specVendor = builder.specVendor;
        this.specVersion = builder.specVersion;
        this.inputArguments = builder.inputArguments;
        this.uptime = builder.uptime;
        this.startTime = builder.startTime;
        this.version = builder.version;
    }

    public String getName() {
        return this.name;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getSpecName() {
        return this.specName;
    }

    public String getSpecVendor() {
        return this.specVendor;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public List<String> getInputArguments() {
        return this.inputArguments;
    }

    public long getUptime() {
        return this.uptime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AgentInfo agentInfo = (AgentInfo)obj;
        if (this.startTime != agentInfo.startTime) {
            return false;
        }
        if (this.uptime != agentInfo.uptime) {
            return false;
        }
        if (this.inputArguments != null ? !this.inputArguments.equals(agentInfo.inputArguments) : agentInfo.inputArguments != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(agentInfo.name) : agentInfo.name != null) {
            return false;
        }
        if (this.specName != null ? !this.specName.equals(agentInfo.specName) : agentInfo.specName != null) {
            return false;
        }
        if (this.specVendor != null ? !this.specVendor.equals(agentInfo.specVendor) : agentInfo.specVendor != null) {
            return false;
        }
        if (this.specVersion != null ? !this.specVersion.equals(agentInfo.specVersion) : agentInfo.specVersion != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(agentInfo.version) : agentInfo.version != null) {
            return false;
        }
        if (this.vmName != null ? !this.vmName.equals(agentInfo.vmName) : agentInfo.vmName != null) {
            return false;
        }
        if (this.vmVendor != null ? !this.vmVendor.equals(agentInfo.vmVendor) : agentInfo.vmVendor != null) {
            return false;
        }
        return !(this.vmVersion != null ? !this.vmVersion.equals(agentInfo.vmVersion) : agentInfo.vmVersion != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.vmName != null ? this.vmName.hashCode() : 0);
        result = 31 * result + (this.vmVendor != null ? this.vmVendor.hashCode() : 0);
        result = 31 * result + (this.vmVersion != null ? this.vmVersion.hashCode() : 0);
        result = 31 * result + (this.specName != null ? this.specName.hashCode() : 0);
        result = 31 * result + (this.specVendor != null ? this.specVendor.hashCode() : 0);
        result = 31 * result + (this.specVersion != null ? this.specVersion.hashCode() : 0);
        result = 31 * result + (this.inputArguments != null ? this.inputArguments.hashCode() : 0);
        result = 31 * result + (int)(this.uptime ^ this.uptime >>> 32);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AgentInfo{name='" + this.name + '\'' + ", vmName='" + this.vmName + '\'' + ", vmVendor='" + this.vmVendor + '\'' + ", vmVersion='" + this.vmVersion + '\'' + ", specName='" + this.specName + '\'' + ", specVendor='" + this.specVendor + '\'' + ", specVersion='" + this.specVersion + '\'' + ", inputArguments=" + this.inputArguments + ", uptime=" + this.uptime + ", startTime=" + this.startTime + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String vmName;
        private String vmVendor;
        private String vmVersion;
        private String specName;
        private String specVendor;
        private String specVersion;
        private List<String> inputArguments;
        private long uptime;
        private long startTime;
        private String version;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public Builder setVmVendor(String vmVendor) {
            this.vmVendor = vmVendor;
            return this;
        }

        public Builder setVmVersion(String vmVersion) {
            this.vmVersion = vmVersion;
            return this;
        }

        public Builder setSpecName(String specName) {
            this.specName = specName;
            return this;
        }

        public Builder setSpecVendor(String specVendor) {
            this.specVendor = specVendor;
            return this;
        }

        public Builder setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
            return this;
        }

        public Builder setInputArguments(List<String> inputArguments) {
            this.inputArguments = inputArguments;
            return this;
        }

        public Builder setUptime(long uptime) {
            this.uptime = uptime;
            return this;
        }

        public Builder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public AgentInfo build() {
            return new AgentInfo(this);
        }
    }
}

