/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.ExecHealthCheck;
import com.spotify.helios.common.descriptors.HttpHealthCheck;
import com.spotify.helios.common.descriptors.TcpHealthCheck;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExecHealthCheck.class, name="exec"), @JsonSubTypes.Type(value=HttpHealthCheck.class, name="http"), @JsonSubTypes.Type(value=TcpHealthCheck.class, name="tcp")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class HealthCheck
extends Descriptor {
    public static final String EXEC = "exec";
    public static final String HTTP = "http";
    public static final String TCP = "tcp";
    private final String type;

    HealthCheck(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkArgument((!type.isEmpty() ? 1 : 0) != 0, (Object)"type is empty");
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static ExecHealthCheck.Builder newExecHealthCheck() {
        return ExecHealthCheck.newBuilder();
    }

    public static HttpHealthCheck.Builder newHttpHealthCheck() {
        return HttpHealthCheck.newBuilder();
    }

    public static TcpHealthCheck.Builder newTcpHealthCheck() {
        return TcpHealthCheck.newBuilder();
    }

    public String toString() {
        return "HealthCheck{type='" + this.type + '\'' + '}';
    }
}

