/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.spotify.helios.common.descriptors.Descriptor;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortMapping
extends Descriptor {
    public static final String TCP = "tcp";
    public static final String UDP = "udp";
    private final String ip;
    private final int internalPort;
    private final Integer externalPort;
    private final String protocol;

    public PortMapping(@JsonProperty(value="ip") @Nullable String ip, @JsonProperty(value="internalPort") int internalPort, @JsonProperty(value="externalPort") @Nullable Integer externalPort, @JsonProperty(value="protocol") @Nullable String protocol) {
        this.ip = ip;
        if (ip != null && !InetAddresses.isInetAddress((String)this.ip)) {
            throw new IllegalArgumentException(ip + " is not a valid IP address.");
        }
        this.internalPort = internalPort;
        this.externalPort = externalPort;
        this.protocol = (String)Optional.fromNullable((Object)protocol).or((Object)TCP);
    }

    public PortMapping(int internalPort, Integer externalPort) {
        this(null, internalPort, externalPort, TCP);
    }

    public PortMapping(int internalPort) {
        this(null, internalPort, null, TCP);
    }

    private PortMapping(Builder builder) {
        this(builder.ip, builder.internalPort, builder.externalPort, (String)Preconditions.checkNotNull((Object)builder.protocol));
    }

    @Nullable
    public String getIp() {
        return this.ip;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public boolean hasExternalPort() {
        return this.externalPort != null;
    }

    @Nullable
    public Integer getExternalPort() {
        return this.externalPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public PortMapping withExternalPort(Integer externalPort) {
        return PortMapping.of(this.internalPort, externalPort, this.protocol);
    }

    public static PortMapping of(int internalPort) {
        return new PortMapping(internalPort);
    }

    public static PortMapping of(int internalPort, Integer externalPort) {
        return new PortMapping(internalPort, externalPort);
    }

    public static PortMapping of(int internalPort, Integer externalPort, String protocol) {
        return new PortMapping(null, internalPort, externalPort, protocol);
    }

    public static PortMapping of(int internalPort, String protocol) {
        return new PortMapping(null, internalPort, null, protocol);
    }

    public static Builder builder() {
        return new Builder().protocol(TCP);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortMapping that = (PortMapping)obj;
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        if (this.internalPort != that.internalPort) {
            return false;
        }
        if (this.externalPort != null ? !this.externalPort.equals(that.externalPort) : that.externalPort != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null);
    }

    public int hashCode() {
        int result = this.internalPort;
        result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
        result = 31 * result + (this.externalPort != null ? this.externalPort.hashCode() : 0);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PortMapping{ip=" + this.ip + ", internalPort=" + this.internalPort + ", externalPort=" + this.externalPort + ", protocol='" + this.protocol + '\'' + '}';
    }

    public static class Builder {
        private String ip;
        private int internalPort;
        private Integer externalPort;
        private String protocol;

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder internalPort(int internalPort) {
            this.internalPort = internalPort;
            return this;
        }

        public Builder externalPort(Integer externalPort) {
            this.externalPort = externalPort;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public PortMapping build() {
            return new PortMapping(this);
        }
    }
}

