/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.ServicePortParameters;
import java.util.Arrays;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServicePorts
extends Descriptor {
    private final Map<String, ServicePortParameters> ports;

    public ServicePorts(@JsonProperty(value="ports") Map<String, ServicePortParameters> ports) {
        this.ports = ports;
    }

    public Map<String, ServicePortParameters> getPorts() {
        return this.ports;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServicePorts that = (ServicePorts)obj;
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return this.ports != null ? this.ports.hashCode() : 0;
    }

    public String toString() {
        return "ServicePorts{ports=" + this.ports + '}';
    }

    public static ServicePorts of(String ... ports) {
        return ServicePorts.of(Arrays.asList(ports));
    }

    private static ServicePorts of(Iterable<String> ports) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String port : ports) {
            builder.put((Object)port, (Object)new ServicePortParameters(null));
        }
        return new ServicePorts((Map<String, ServicePortParameters>)builder.build());
    }
}

