/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.system.SystemTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class QueryFailureTest
extends SystemTestBase {
    @Test
    public void testHostList() throws Exception {
        this.startDefaultMaster(new String[0]);
        String result = this.cli("hosts", "framazama");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"matched no hosts"));
    }

    @Test
    public void testQuietHostList() throws Exception {
        this.startDefaultMaster(new String[0]);
        String result = this.cli("hosts", "framazama", "-q");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testJobList() throws Exception {
        this.startDefaultMaster(new String[0]);
        String result = this.cli("jobs", "framazama");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"matched no jobs"));
    }

    @Test
    public void testQuietJobList() throws Exception {
        this.startDefaultMaster(new String[0]);
        String result = this.cli("jobs", "framazama", "-q");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testJobStatusJobFilter() throws Exception {
        this.startDefaultMaster(new String[0]);
        String result2 = this.cli("status", "-j", "framazama");
        MatcherAssert.assertThat((Object)result2, (Matcher)Matchers.containsString((String)"matched no jobs"));
    }

    @Test
    public void testJobStatusHostFilter() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).setPorts(Job.EMPTY_PORTS).build();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        String result = this.cli("status", "--host", "framazama");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"matched no hosts"));
    }
}

