/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.ZooKeeperTestManager;
import com.spotify.helios.ZooKeeperTestingServerManager;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.system.SystemTestBase;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperRestoreTest
extends SystemTestBase {
    private final Job fooJob;
    private final ZooKeeperTestingServerManager zkc;
    private HeliosClient client;
    private Path backupDir;

    public ZooKeeperRestoreTest() {
        this.fooJob = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).build();
        this.zkc = new ZooKeeperTestingServerManager();
    }

    @Override
    protected ZooKeeperTestManager zooKeeperTestManager() {
        return this.zkc;
    }

    @Before
    public void setup() throws Exception {
        this.backupDir = Files.createTempDirectory("helios-zk-updating-persistent-dir-test-backup-", new FileAttribute[0]);
        this.startDefaultMaster(new String[0]);
        this.client = this.defaultClient();
        CreateJobResponse created = (CreateJobResponse)this.client.createJob(this.fooJob).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
    }

    @After
    public void teardown() throws Exception {
        FileUtils.deleteQuietly((File)this.backupDir.toFile());
    }

    @Test
    public void verifyAgentReRegistersAfterRestore() throws Exception {
        this.zkc.backup(this.backupDir);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        this.zkc.stop();
        this.zkc.restore(this.backupDir);
        this.zkc.start();
        this.awaitHostRegistered(this.client, this.testHost(), 200, TimeUnit.SECONDS);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
    }

    @Test
    public void verifyAgentPushesTaskStateAfterRestore() throws Exception {
        AgentMain agent1 = this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        agent1.stopAsync().awaitTerminated();
        Deployment deployment = Deployment.of((JobId)this.fooJob.getId(), (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)this.client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        this.zkc.backup(this.backupDir);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        this.awaitJobState(this.client, this.testHost(), this.fooJob.getId(), TaskStatus.State.RUNNING, 200, TimeUnit.SECONDS);
        this.zkc.stop();
        this.zkc.restore(this.backupDir);
        this.zkc.start();
        this.awaitJobState(this.client, this.testHost(), this.fooJob.getId(), TaskStatus.State.RUNNING, 200, TimeUnit.SECONDS);
        this.zkc.curator().delete().forPath(Paths.statusHostJob((String)this.testHost(), (JobId)this.fooJob.getId()));
    }
}

