/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.spotify.helios.Polling;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.system.SystemTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CliJobCreationTest
extends SystemTestBase {
    private final Integer externalPort = this.temporaryPorts().localPort("external");
    private final String testJobNameAndVersion = this.testJobName + ":" + this.testJobVersion;

    @Before
    public void initialize() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)200L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = CliJobCreationTest.this.cli("masters", new String[0]);
                return output.contains(CliJobCreationTest.this.masterName()) ? output : null;
            }
        });
    }

    @Test
    public void testMergeFileAndCliArgs() throws Exception {
        ImmutableMap ports = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)5000, (Integer)this.externalPort));
        ImmutableMap registration = ImmutableMap.of((Object)ServiceEndpoint.of((String)"foo-service", (String)"hm"), (Object)ServicePorts.of((String[])new String[]{"foo"}), (Object)ServiceEndpoint.of((String)"bar-service", (String)"http"), (Object)ServicePorts.of((String[])new String[]{"bar"}));
        ImmutableMap env = ImmutableMap.of((Object)"BAD", (Object)"f00d");
        HashMap volumes = Maps.newHashMap();
        volumes.put("/etc/spotify/secret-keys.yaml:ro", "/etc/spotify/secret-keys.yaml");
        Job.Builder builder = Job.newBuilder().setCommand((List)Lists.newArrayList((Object[])new String[]{"server", "foo-service.yaml"})).setEnv((Map)env).setPorts((Map)ports).setRegistration((Map)registration).setVolumes((Map)volumes).setCreatingUser("test-user");
        Job job = builder.build();
        String jobConfigJsonString = job.toJsonString();
        File file = this.temporaryFolder.newFile();
        String absolutePath = file.getAbsolutePath();
        try (FileOutputStream outFile = new FileOutputStream(file);){
            outFile.write(Charsets.UTF_8.encode(jobConfigJsonString).array());
            this.cli("create", "--file", absolutePath, this.testJobNameAndVersion, "busybox");
            String actualJobConfigJson = this.cli("inspect", this.testJobNameAndVersion, "--json");
            Job actualJob = (Job)Json.read((String)actualJobConfigJson, Job.class);
            Job.Builder actualJobBuilder = actualJob.toBuilder();
            builder.setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox");
            this.assertJobEquals(builder.build(), actualJobBuilder.build());
        }
    }

    @Test
    public void testSuccessJsonOutput() throws Exception {
        String output = this.cli("create", "--json", this.testJobNameAndVersion, "busybox");
        CreateJobResponse createJobResponse = (CreateJobResponse)Json.read((String)output, CreateJobResponse.class);
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)createJobResponse.getStatus());
        Assert.assertEquals(new ArrayList(), (Object)createJobResponse.getErrors());
        Assert.assertTrue((boolean)createJobResponse.getId().startsWith(this.testJobNameAndVersion));
    }

    @Test
    public void testInvalidJobJsonOutput() throws Exception {
        String output = this.cli("create", "--json", this.testJobNameAndVersion, "DOES_NOT_LIKE_AT_ALL-CAPITALS");
        CreateJobResponse createJobResponse = (CreateJobResponse)Json.read((String)output, CreateJobResponse.class);
        Assert.assertEquals((Object)CreateJobResponse.Status.INVALID_JOB_DEFINITION, (Object)createJobResponse.getStatus());
        Assert.assertTrue((boolean)createJobResponse.getId().startsWith(this.testJobNameAndVersion));
    }

    @Test
    public void testTemplateUnknownJobJsonOutput() throws Exception {
        String output = this.cli("create", "--json", "--template", "non-existant-job", this.testJobNameAndVersion, "busybox");
        CreateJobResponse createJobResponse = (CreateJobResponse)Json.read((String)output, CreateJobResponse.class);
        Assert.assertEquals((Object)CreateJobResponse.Status.UNKNOWN_JOB, (Object)createJobResponse.getStatus());
    }

    @Test
    public void testTemplateAmbiguousJobJsonOutput() throws Exception {
        this.cli("create", this.testJobNameAndVersion, "busybox");
        this.cli("create", this.testJobNameAndVersion + "1", "busybox");
        String output = this.cli("create", "--json", "--template", this.testJobNameAndVersion, this.testJobNameAndVersion, "busybox");
        CreateJobResponse createJobResponse = (CreateJobResponse)Json.read((String)output, CreateJobResponse.class);
        Assert.assertEquals((Object)CreateJobResponse.Status.AMBIGUOUS_JOB_REFERENCE, (Object)createJobResponse.getStatus());
    }

    @Test
    public void testMergeFileAndCliArgsEnvPrecedence() throws Exception {
        String redundantEnvKey = "BAD";
        ImmutableMap ports = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)5000, (Integer)this.externalPort));
        ImmutableMap registration = ImmutableMap.of((Object)ServiceEndpoint.of((String)"foo-service", (String)"hm"), (Object)ServicePorts.of((String[])new String[]{"foo"}), (Object)ServiceEndpoint.of((String)"bar-service", (String)"http"), (Object)ServicePorts.of((String[])new String[]{"bar"}));
        ImmutableMap env = ImmutableMap.of((Object)"BAD", (Object)"f00d");
        HashMap volumes = Maps.newHashMap();
        volumes.put("/etc/spotify/secret-keys.yaml:ro", "/etc/spotify/secret-keys.yaml");
        Job.Builder builder = Job.newBuilder().setCommand((List)Lists.newArrayList((Object[])new String[]{"server", "foo-service.yaml"})).setEnv((Map)env).setPorts((Map)ports).setRegistration((Map)registration).setVolumes((Map)volumes).setCreatingUser("test-user");
        Job job = builder.build();
        String jobConfigJsonString = job.toJsonString();
        File file = this.temporaryFolder.newFile();
        String absolutePath = file.getAbsolutePath();
        try (FileOutputStream outFile = new FileOutputStream(file);){
            outFile.write(Charsets.UTF_8.encode(jobConfigJsonString).array());
            this.cli("create", "--file", absolutePath, this.testJobNameAndVersion, "busybox", "--env", "BAD=FOOD");
            String actualJobConfigJson = this.cli("inspect", this.testJobNameAndVersion, "--json");
            Job actualJob = (Job)Json.read((String)actualJobConfigJson, Job.class);
            Job.Builder actualJobBuilder = actualJob.toBuilder();
            builder.setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setEnv((Map)ImmutableMap.of((Object)"BAD", (Object)"FOOD"));
            Assert.assertEquals((Object)builder.build(), (Object)actualJobBuilder.build());
        }
    }
}

