/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.common.protocol.TaskStatusEvents;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class JobHistoryTest
extends SystemTestBase {
    @Test
    public void testJobHistory() throws Exception {
        TaskStatusEvent event;
        this.startDefaultMaster(new String[0]);
        final HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        final JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox", IDLE_COMMAND);
        this.deployJob(jobId, this.testHost());
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 200, TimeUnit.SECONDS);
        this.undeployJob(jobId, this.testHost());
        this.awaitTaskGone(client, this.testHost(), jobId, 200L, TimeUnit.SECONDS);
        TaskStatusEvents events = (TaskStatusEvents)Polling.await((long)40L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TaskStatusEvents>(){

            @Override
            public TaskStatusEvents call() throws Exception {
                TaskStatusEvents events = (TaskStatusEvents)client.jobHistory(jobId).get();
                int size = events.getEvents().size();
                if (size == 0) {
                    return null;
                }
                int requiredEventCount = -1;
                for (int i = 0; i < size; ++i) {
                    if (((TaskStatusEvent)events.getEvents().get(i)).getStatus().getState() == TaskStatus.State.PULLING_IMAGE) continue;
                    requiredEventCount = i + 4;
                    break;
                }
                if (requiredEventCount == -1) {
                    return null;
                }
                if (size < requiredEventCount) {
                    return null;
                }
                return events;
            }
        });
        List eventsList = events.getEvents();
        int n = 0;
        while ((event = (TaskStatusEvent)eventsList.get(n)).getStatus().getState() == TaskStatus.State.PULLING_IMAGE) {
            Assert.assertNull((Object)event.getStatus().getContainerId());
            ++n;
        }
        TaskStatusEvent event1 = (TaskStatusEvent)eventsList.get(n);
        Assert.assertEquals((Object)TaskStatus.State.CREATING, (Object)event1.getStatus().getState());
        Assert.assertNull((Object)event1.getStatus().getContainerId());
        TaskStatusEvent event2 = (TaskStatusEvent)eventsList.get(n + 1);
        Assert.assertEquals((Object)TaskStatus.State.STARTING, (Object)event2.getStatus().getState());
        Assert.assertNotNull((Object)event2.getStatus().getContainerId());
        TaskStatusEvent event3 = (TaskStatusEvent)eventsList.get(n + 2);
        Assert.assertEquals((Object)TaskStatus.State.RUNNING, (Object)event3.getStatus().getState());
        TaskStatusEvent event4 = (TaskStatusEvent)eventsList.get(n + 3);
        TaskStatus.State finalState = event4.getStatus().getState();
        Assert.assertTrue((finalState == TaskStatus.State.EXITED || finalState == TaskStatus.State.STOPPED ? 1 : 0) != 0);
    }
}

