/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class PredefinedPortImageDeploymentTest
extends SystemTestBase {
    private final int externalPort;

    public PredefinedPortImageDeploymentTest() {
        this.externalPort = this.temporaryPorts.localPort("external");
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        HeliosClient client = this.defaultClient();
        Job job1 = Job.newBuilder().setName(this.testTag + "memcached").setVersion("v1").setImage("rohan/memcached-mini").build();
        JobId jobId1 = job1.getId();
        client.createJob(job1).get();
        Job job2 = Job.newBuilder().setName(this.testTag + "memcached").setVersion("v2").setImage("rohan/memcached-mini").setPorts((Map)ImmutableMap.of((Object)"tcp", (Object)PortMapping.of((int)11211, (Integer)this.externalPort))).build();
        JobId jobId2 = job2.getId();
        client.createJob(job2).get();
        this.awaitHostRegistered(client, this.testHost(), 10, TimeUnit.MINUTES);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        client.deploy(Deployment.of((JobId)jobId1, (Goal)Goal.START), this.testHost()).get();
        client.deploy(Deployment.of((JobId)jobId2, (Goal)Goal.START), this.testHost()).get();
        this.awaitJobState(client, this.testHost(), jobId1, TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
        this.awaitJobState(client, this.testHost(), jobId2, TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
    }
}

