/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.ZooKeeperClusterTestManager;
import com.spotify.helios.ZooKeeperTestManager;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClusterDeploymentTest
extends SystemTestBase {
    public static final int HOSTS = Integer.valueOf((String)Optional.fromNullable((Object)System.getenv("HELIOS_CLUSTER_DEPLOYMENT_TEST_HOSTS")).or((Object)"10"));
    private final Job job;
    private final ZooKeeperClusterTestManager zkc;
    private HeliosClient client;

    public ClusterDeploymentTest() {
        this.job = Job.newBuilder().setName("foo").setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).build();
        this.zkc = new ZooKeeperClusterTestManager();
    }

    @Override
    protected ZooKeeperTestManager zooKeeperTestManager() {
        return this.zkc;
    }

    @Before
    public void setup() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.client = this.defaultClient();
    }

    @Test
    public void verifyCanDeployOnSeveralHosts() throws Exception {
        int i;
        CreateJobResponse created = (CreateJobResponse)this.client.createJob(this.job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        ArrayList agents = Lists.newArrayList();
        for (int i2 = 0; i2 < HOSTS; ++i2) {
            AgentMain agent = this.startDefaultAgent(this.host(i2), "--no-http", "--no-metrics");
            agents.add(agent);
        }
        for (AgentMain agent : agents) {
            agent.awaitRunning();
        }
        for (i = 0; i < HOSTS; ++i) {
            this.awaitHostStatus(this.client, this.host(i), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        }
        for (i = 0; i < HOSTS; ++i) {
            this.deploy(this.job, this.host(i));
        }
        for (i = 0; i < HOSTS; ++i) {
            this.awaitJobState(this.client, this.host(i), this.job.getId(), TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
        }
        for (i = 0; i < HOSTS; ++i) {
            this.undeploy(this.job.getId(), this.host(i));
        }
        for (i = 0; i < HOSTS; ++i) {
            this.awaitTaskGone(this.client, this.host(i), this.job.getId(), 10L, TimeUnit.MINUTES);
        }
    }

    private String host(int i) throws InterruptedException, ExecutionException {
        return this.testHost() + i;
    }

    private void deploy(Job job, String host) throws Exception {
        Futures.addCallback((ListenableFuture)this.client.deploy(Deployment.of((JobId)job.getId(), (Goal)Goal.START), host), (FutureCallback)new FutureCallback<JobDeployResponse>(){

            public void onSuccess(JobDeployResponse result) {
                Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)result.getStatus());
            }

            public void onFailure(Throwable t) {
                Assert.fail((String)"deploy failed");
            }
        });
    }

    private void undeploy(JobId jobId, String host) throws Exception {
        Futures.addCallback((ListenableFuture)this.client.undeploy(jobId, host), (FutureCallback)new FutureCallback<JobUndeployResponse>(){

            public void onSuccess(JobUndeployResponse result) {
                Assert.assertEquals((Object)JobUndeployResponse.Status.OK, (Object)result.getStatus());
            }

            public void onFailure(Throwable t) {
                Assert.fail((String)"undeploy failed");
            }
        });
    }
}

