/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.spotify.helios.TemporaryPorts;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DeregisterTest
extends SystemTestBase {
    @Rule
    public final TemporaryPorts ports = TemporaryPorts.create();

    @Test
    public void testDeregisterHostThatDoesntExist() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        HeliosClient client = this.defaultClient();
        HostDeregisterResponse deregisterResponse = (HostDeregisterResponse)client.deregisterHost(host).get();
        Assert.assertEquals((Object)HostDeregisterResponse.Status.NOT_FOUND, (Object)deregisterResponse.getStatus());
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        String host = this.testHost();
        AgentMain agent = this.startDefaultAgent(host, new String[0]);
        HeliosClient client = this.defaultClient();
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).setPorts((Map)ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.ports.localPort("bar")))).build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        this.awaitHostRegistered(client, host, 10, TimeUnit.MINUTES);
        this.awaitHostStatus(client, host, HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, host).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        this.awaitJobState(client, host, jobId, TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
        agent.stopAsync().awaitTerminated();
        HostDeregisterResponse deregisterResponse = (HostDeregisterResponse)client.deregisterHost(host).get();
        Assert.assertEquals((Object)HostDeregisterResponse.Status.OK, (Object)deregisterResponse.getStatus());
        JobDeleteResponse deleteResponse = (JobDeleteResponse)client.deleteJob(jobId).get();
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)deleteResponse.getStatus());
    }
}

