/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.ThrottleState;
import com.spotify.helios.system.SystemTestBase;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class FlappingTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        final String host = this.testHost();
        this.startDefaultAgent(host, new String[0]);
        final HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, host, HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        Job flapper = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setCommand(Arrays.asList("nc", "-p", "4711", "-l")).addPort("poke", PortMapping.of((int)4711)).build();
        final JobId jobId = this.createJob(flapper);
        this.deployJob(jobId, host);
        this.awaitTaskState(jobId, host, TaskStatus.State.RUNNING);
        Polling.await((long)10L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JobStatus jobStatus = (JobStatus)FlappingTest.this.getOrNull(client.jobStatus(jobId));
                TaskStatus taskStatus = (TaskStatus)jobStatus.getTaskStatuses().get(host);
                if (taskStatus.getThrottled() == ThrottleState.FLAPPING) {
                    return true;
                }
                PortMapping port = (PortMapping)taskStatus.getPorts().get("poke");
                assert (port.getExternalPort() != null);
                FlappingTest.this.poke(port.getExternalPort());
                return null;
            }
        });
        this.awaitJobThrottle(client, host, jobId, ThrottleState.NO, 10, TimeUnit.MINUTES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean poke(int port) {
        try (Socket ignored = new Socket(DOCKER_HOST.address(), port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

