/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JobExpirationTest
extends SystemTestBase {
    private final DockerClient docker = new DefaultDockerClient(DOCKER_HOST.uri());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        final HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        final JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox", (List<String>)IDLE_COMMAND, DateTime.now().plusSeconds(10).toDate());
        this.deployJob(jobId, this.testHost());
        TaskStatus taskStatus = this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 40, TimeUnit.SECONDS);
        Polling.await((long)3L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<JobId>(){

            @Override
            public JobId call() throws Exception {
                if (((Map)client.jobs().get()).containsKey(jobId)) {
                    return null;
                }
                return jobId;
            }
        });
        int expectedExitCode = -1;
        if (this.docker.info().executionDriver().startsWith("lxc-")) {
            expectedExitCode = 0;
        }
        ContainerExit exit = this.docker.waitContainer(taskStatus.getContainerId());
        Assert.assertThat((Object)exit.statusCode(), (Matcher)Is.is((Object)expectedExitCode));
    }
}

