/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.Iterables;
import com.spotify.helios.MockServiceRegistrarRegistry;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import com.spotify.helios.system.ServiceRegistrationTestBase;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MasterServiceRegistrationTest
extends ServiceRegistrationTestBase {
    @Mock
    public ServiceRegistrar registrar;
    @Captor
    public ArgumentCaptor<ServiceRegistration> registrationCaptor;
    final String registryAddress = this.uniqueRegistryAddress();

    @Before
    public void setup() {
        MockServiceRegistrarRegistry.set((String)this.registryAddress, (ServiceRegistrar)this.registrar);
    }

    @After
    public void teardown() {
        MockServiceRegistrarRegistry.remove((String)this.registryAddress);
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster("--service-registry=" + this.registryAddress);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.MINUTES.toMillis(10L))))).register((ServiceRegistration)this.registrationCaptor.capture());
        ServiceRegistration registration = (ServiceRegistration)this.registrationCaptor.getValue();
        ServiceRegistration.Endpoint endpoint = (ServiceRegistration.Endpoint)Iterables.getOnlyElement((Iterable)registration.getEndpoints());
        Assert.assertEquals((Object)"http", (Object)endpoint.getProtocol());
        Assert.assertEquals((Object)"helios", (Object)endpoint.getName());
        Assert.assertEquals((long)this.masterPort(), (long)endpoint.getPort());
    }
}

