/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="This needs the syslog-redirector")
public class SyslogRedirectionTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), "--syslog-redirect", "10.0.3.1:6514");
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        try (DefaultDockerClient dockerClient = new DefaultDockerClient(DOCKER_HOST.uri());){
            String log;
            List<String> command = Arrays.asList("sh", "-c", "echo should-be-redirected");
            JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox", command, (ImmutableMap<String, String>)ImmutableMap.of((Object)"FOO", (Object)"4711", (Object)"BAR", (Object)"deadbeef"));
            this.deployJob(jobId, this.testHost());
            TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
            try (LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParameter[]{DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR});){
                log = logs.readFully();
            }
            Assert.assertEquals((Object)"", (Object)log);
        }
    }
}

