/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Preconditions;
import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VolumeTest
extends SystemTestBase {
    private HeliosClient client;
    private Job job;

    @Before
    public void setup() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").addVolume("/volume").addVolume("/urandom", "/dev/urandom").addVolume("/hostdev", "/dev").setCommand(Arrays.asList("sh", "-c", "echo foo > /volume/bar; nc -p 4711 -le dd if=/volume/bar;nc -p 4712 -lle dd if=/urandom bs=1 count=4")).addPort("bar", PortMapping.of((int)4711)).addPort("urandom", PortMapping.of((int)4712)).build();
    }

    @Test
    public void testClient() throws Exception {
        CreateJobResponse created = (CreateJobResponse)this.client.createJob(this.job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        this.assertVolumes();
    }

    @Test
    public void testCli() throws Exception {
        this.createJob(this.job);
        this.assertVolumes();
    }

    public void assertVolumes() throws Exception {
        JobId jobId = this.job.getId();
        this.awaitHostRegistered(this.client, this.testHost(), 10, TimeUnit.MINUTES);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)this.client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        TaskStatus taskStatus = this.awaitJobState(this.client, this.testHost(), jobId, TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
        Assert.assertEquals((Object)this.job, (Object)taskStatus.getJob());
        Integer bar = ((PortMapping)taskStatus.getPorts().get("bar")).getExternalPort();
        Integer urandom = ((PortMapping)taskStatus.getPorts().get("urandom")).getExternalPort();
        assert (bar != null);
        assert (urandom != null);
        String foo = this.recvUtf8(bar, 3);
        Assert.assertEquals((Object)"foo", (Object)foo);
        this.recv(urandom, 4);
    }

    private String recvUtf8(int port, int n) throws Exception {
        byte[] bytes = this.recv(port, n);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] recv(final int port, final int n) throws Exception {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"n must be > 0");
        return (byte[])Polling.await((long)10L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<byte[]>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public byte[] call() {
                try (Socket s = new Socket(SystemTestBase.DOCKER_HOST.address(), port);){
                    byte[] bytes = new byte[n];
                    InputStream is = s.getInputStream();
                    int first = is.read();
                    if (first == -1) {
                        byte[] byArray2 = null;
                        return byArray2;
                    }
                    bytes[0] = (byte)first;
                    for (int i = 1; i < n; ++i) {
                        bytes[i] = (byte)is.read();
                    }
                    byte[] byArray = bytes;
                    return byArray;
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }
}

