/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.Polling;
import com.spotify.helios.ZooKeeperClusterTestManager;
import com.spotify.helios.ZooKeeperTestManager;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperHeliosFailoverTest
extends SystemTestBase {
    private final Job fooJob;
    private final Job barJob;
    private final ZooKeeperClusterTestManager zkc;
    private HeliosClient client;

    public ZooKeeperHeliosFailoverTest() {
        this.fooJob = Job.newBuilder().setName(this.testTag + "foo").setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).build();
        this.barJob = Job.newBuilder().setName(this.testTag + "bar").setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).build();
        this.zkc = new ZooKeeperClusterTestManager();
    }

    @Override
    protected ZooKeeperTestManager zooKeeperTestManager() {
        return this.zkc;
    }

    @Before
    public void setup() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.client = this.defaultClient();
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
    }

    @Test
    public void verifyCanDeployWithOnePeerDead() throws Exception {
        this.deploy(this.fooJob);
        this.zkc.stopPeer(0L);
        this.undeploy(this.fooJob.getId());
        this.deploy(this.barJob);
    }

    @Test
    public void verifyCanDeployWithOneNodeDeadAfterOneNodeDataLoss() throws Exception {
        this.deploy(this.fooJob);
        try {
            this.zkc.curator().create().forPath("/barrier");
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        this.zkc.stopPeer(0L);
        this.zkc.resetPeer(0L);
        this.zkc.startPeer(0L);
        Polling.await((long)10L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ZooKeeperHeliosFailoverTest.this.zkc.peerCurator(0L).checkExists().forPath("/barrier");
            }
        });
        this.zkc.stopPeer(1L);
        this.undeploy(this.fooJob.getId());
        this.deploy(this.barJob);
    }

    private void deploy(Job job) throws Exception {
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)this.client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)this.client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        this.awaitJobState(this.client, this.testHost(), jobId, TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
    }

    private void undeploy(JobId jobId) throws Exception {
        JobStatus jobStatus = (JobStatus)this.client.jobStatus(jobId).get();
        Assert.assertEquals((Object)TaskStatus.State.RUNNING, (Object)((TaskStatus)jobStatus.getTaskStatuses().get(this.testHost())).getState());
        JobUndeployResponse undeployed = (JobUndeployResponse)this.client.undeploy(jobId, this.testHost()).get();
        Assert.assertEquals((Object)JobUndeployResponse.Status.OK, (Object)undeployed.getStatus());
        this.awaitTaskGone(this.client, this.testHost(), jobId, 10L, TimeUnit.MINUTES);
    }
}

