/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZooKeeperNamespacingTest
extends SystemTestBase {
    private static final String NAMESPACE = "testing";

    @BeforeClass
    public static void setUpZkNamespace() {
        zooKeeperNamespace = NAMESPACE;
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster("--zk-namespace", NAMESPACE);
        this.startDefaultAgent(this.testHost(), "--zk-namespace", NAMESPACE);
        this.awaitHostRegistered(this.testHost(), 10L, TimeUnit.MINUTES);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        ExponentialBackoffRetry zooKeeperRetryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework framework = CuratorFrameworkFactory.builder().retryPolicy((RetryPolicy)zooKeeperRetryPolicy).connectString(this.zk().connectString()).connectionTimeoutMs(30000).sessionTimeoutMs(30000).build();
        framework.start();
        List result = (List)framework.getChildren().forPath("/");
        Collections.sort(result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)NAMESPACE, result.get(0));
        Assert.assertEquals((Object)"zookeeper", result.get(1));
    }
}

