/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.ZooKeeperTestManager;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.HeliosException;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.utils.EnsurePath;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MasterRespondsWithNoZKTest
extends SystemTestBase {
    @Override
    protected ZooKeeperTestManager zooKeeperTestManager() {
        ZooKeeperTestManager testManager = (ZooKeeperTestManager)Mockito.mock(ZooKeeperTestManager.class);
        MockCuratorClientFactory mockCuratorClientFactory = new MockCuratorClientFactory();
        CuratorFramework curator = mockCuratorClientFactory.newClient(null, 0, 0, null, null);
        Mockito.when((Object)testManager.curator()).thenReturn((Object)curator);
        Mockito.when((Object)testManager.connectString()).thenReturn((Object)"127.0.0.1");
        return testManager;
    }

    @Override
    protected void tearDownJobs() {
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMasterDontWaitForZK(new MockCuratorClientFactory(), "--zk-connection-timeout", "1");
        HeliosClient client = this.defaultClient();
        try {
            String result = (String)((List)client.listMasters().get()).get(0);
            Assert.fail((String)("Exception should have been thrown, as ZK doesnt exist - got " + result));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof HeliosException));
        }
    }

    private static class MockCuratorClientFactory
    implements CuratorClientFactory {
        private MockCuratorClientFactory() {
        }

        public CuratorFramework newClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, RetryPolicy retryPolicy, String namespace) {
            CuratorFramework curator = (CuratorFramework)Mockito.mock(CuratorFramework.class);
            RetryLoop retryLoop = (RetryLoop)Mockito.mock(RetryLoop.class);
            Mockito.when((Object)retryLoop.shouldContinue()).thenReturn((Object)false);
            CuratorZookeeperClient czkClient = (CuratorZookeeperClient)Mockito.mock(CuratorZookeeperClient.class);
            Mockito.when((Object)czkClient.newRetryLoop()).thenReturn((Object)retryLoop);
            Mockito.when((Object)curator.getZookeeperClient()).thenReturn((Object)czkClient);
            Listenable mockListener = (Listenable)Mockito.mock(Listenable.class);
            Mockito.when((Object)curator.getConnectionStateListenable()).thenReturn((Object)mockListener);
            GetChildrenBuilder builder = (GetChildrenBuilder)Mockito.mock(GetChildrenBuilder.class);
            Mockito.when((Object)curator.getChildren()).thenReturn((Object)builder);
            try {
                Mockito.when((Object)builder.forPath(Matchers.anyString())).thenThrow(new Throwable[]{new KeeperException.ConnectionLossException()});
            }
            catch (Exception e) {
                // empty catch block
            }
            Mockito.when((Object)curator.newNamespaceAwareEnsurePath(Matchers.anyString())).thenReturn(Mockito.mock(EnsurePath.class));
            return curator;
        }
    }
}

