/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.Maps;
import com.spotify.helios.MockServiceRegistrarRegistry;
import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HealthCheck;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.HttpHealthCheck;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.TcpHealthCheck;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import com.spotify.helios.system.ServiceRegistrationTestBase;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class HealthCheckTest
extends ServiceRegistrationTestBase {
    @Mock
    public ServiceRegistrar registrar;
    @Captor
    public ArgumentCaptor<ServiceRegistration> registrationCaptor;
    final String registryAddress = this.uniqueRegistryAddress();

    @Before
    public void setup() {
        MockServiceRegistrarRegistry.set((String)this.registryAddress, (ServiceRegistrar)this.registrar);
    }

    @After
    public void teardown() {
        MockServiceRegistrarRegistry.remove((String)this.registryAddress);
    }

    @Test
    public void testTcp() throws Exception {
        this.startDefaultMaster(new String[0]);
        final HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--service-registry=" + this.registryAddress);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        TcpHealthCheck healthCheck = TcpHealthCheck.of((String)"health");
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setCommand(Arrays.asList("sh", "-c", "nc -l -p 4711 && nc -l -p 4712")).addPort("poke", PortMapping.of((int)4711)).addPort("health", PortMapping.of((int)4712)).addRegistration(ServiceEndpoint.of((String)"foo_service", (String)"foo_proto"), ServicePorts.of((String[])new String[]{"health"})).setHealthCheck((HealthCheck)healthCheck).build();
        final JobId jobId = this.createJob(job);
        this.deployJob(jobId, this.testHost());
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.HEALTHCHECKING);
        Thread.sleep(3000L);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.never())).register((ServiceRegistration)Matchers.any(ServiceRegistration.class));
        Polling.await((long)200L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JobStatus jobStatus = (JobStatus)HealthCheckTest.this.getOrNull(client.jobStatus(jobId));
                TaskStatus taskStatus = (TaskStatus)jobStatus.getTaskStatuses().get(HealthCheckTest.this.testHost());
                PortMapping port = (PortMapping)taskStatus.getPorts().get("poke");
                assert (port.getExternalPort() != null);
                if (HealthCheckTest.this.poke(port.getExternalPort())) {
                    return true;
                }
                return null;
            }
        });
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.RUNNING);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(200L))))).register((ServiceRegistration)this.registrationCaptor.capture());
        ServiceRegistration serviceRegistration = (ServiceRegistration)this.registrationCaptor.getValue();
        HashMap registered = Maps.newHashMap();
        for (ServiceRegistration.Endpoint endpoint : serviceRegistration.getEndpoints()) {
            registered.put(endpoint.getName(), endpoint);
        }
        Assert.assertEquals((String)"wrong service", (Object)"foo_service", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getName());
        Assert.assertEquals((String)"wrong protocol", (Object)"foo_proto", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getProtocol());
    }

    @Test
    public void testHttp() throws Exception {
        this.startDefaultMaster(new String[0]);
        final HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--service-registry=" + this.registryAddress);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        HttpHealthCheck healthCheck = HttpHealthCheck.of((String)"http", (String)"/");
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("rohan/nginx-alpine").setCommand(Arrays.asList("sh", "-c", "nc -l -p 4711 && nginx -g 'daemon off;'")).addPort("poke", PortMapping.of((int)4711)).addPort("http", PortMapping.of((int)80)).addRegistration(ServiceEndpoint.of((String)"foo_service", (String)"foo_proto"), ServicePorts.of((String[])new String[]{"http"})).setHealthCheck((HealthCheck)healthCheck).build();
        final JobId jobId = this.createJob(job);
        this.deployJob(jobId, this.testHost());
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.HEALTHCHECKING);
        Thread.sleep(3000L);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.never())).register((ServiceRegistration)Matchers.any(ServiceRegistration.class));
        Polling.await((long)200L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JobStatus jobStatus = (JobStatus)HealthCheckTest.this.getOrNull(client.jobStatus(jobId));
                TaskStatus taskStatus = (TaskStatus)jobStatus.getTaskStatuses().get(HealthCheckTest.this.testHost());
                PortMapping port = (PortMapping)taskStatus.getPorts().get("poke");
                assert (port.getExternalPort() != null);
                if (HealthCheckTest.this.poke(port.getExternalPort())) {
                    return true;
                }
                return null;
            }
        });
        this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.RUNNING);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(200L))))).register((ServiceRegistration)this.registrationCaptor.capture());
        ServiceRegistration serviceRegistration = (ServiceRegistration)this.registrationCaptor.getValue();
        HashMap registered = Maps.newHashMap();
        for (ServiceRegistration.Endpoint endpoint : serviceRegistration.getEndpoints()) {
            registered.put(endpoint.getName(), endpoint);
        }
        Assert.assertEquals((String)"wrong service", (Object)"foo_service", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getName());
        Assert.assertEquals((String)"wrong protocol", (Object)"foo_proto", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getProtocol());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean poke(int port) {
        try (Socket ignored = new Socket(DOCKER_HOST.address(), port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

