/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class NamespaceTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        String id = "test-" + Integer.toHexString(new SecureRandom().nextInt());
        String namespace = "helios-" + id;
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--id=" + id);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        this.awaitHostRegistered(client, this.testHost(), 200, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 200, TimeUnit.SECONDS);
        try (DockerClient docker = this.getNewDockerClient();){
            List containers = docker.listContainers(new DockerClient.ListContainersParam[0]);
            Container jobContainer = null;
            for (Container container : containers) {
                for (String name : container.names()) {
                    if (!name.startsWith("/" + namespace)) continue;
                    jobContainer = container;
                }
            }
            Assert.assertNotNull(jobContainer);
        }
    }
}

