/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class PortCollisionJobTest
extends SystemTestBase {
    private final int externalPort;

    public PortCollisionJobTest() {
        this.externalPort = this.temporaryPorts.localPort("external");
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        Job job1 = Job.newBuilder().setName(this.testTag + "foo").setVersion("1").setImage("busybox").setCommand(IDLE_COMMAND).setPorts((Map)ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)10001, (Integer)this.externalPort))).build();
        Job job2 = Job.newBuilder().setName(this.testTag + "bar").setVersion("1").setImage("busybox").setCommand(IDLE_COMMAND).setPorts((Map)ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)10002, (Integer)this.externalPort))).build();
        CreateJobResponse created1 = (CreateJobResponse)client.createJob(job1).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created1.getStatus());
        CreateJobResponse created2 = (CreateJobResponse)client.createJob(job2).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created2.getStatus());
        Deployment deployment1 = Deployment.of((JobId)job1.getId(), (Goal)Goal.STOP);
        JobDeployResponse deployed1 = (JobDeployResponse)client.deploy(deployment1, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed1.getStatus());
        Deployment deployment2 = Deployment.of((JobId)job2.getId(), (Goal)Goal.STOP);
        JobDeployResponse deployed2 = (JobDeployResponse)client.deploy(deployment2, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.PORT_CONFLICT, (Object)deployed2.getStatus());
    }
}

