/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoggingTestWatcher
extends TestWatcher {
    private static final Logger log = LoggerFactory.getLogger(LoggingTestWatcher.class);

    LoggingTestWatcher() {
    }

    protected void starting(Description description) {
        if (Boolean.getBoolean("logToFile")) {
            String name = description.getClassName() + "_" + description.getMethodName();
            this.setupFileLogging(name);
        }
        log.info(Strings.repeat((String)"=", (int)80));
        log.info("STARTING: {}: {}", (Object)description.getClassName(), (Object)description.getMethodName());
        log.info(Strings.repeat((String)"=", (int)80));
    }

    protected void succeeded(Description description) {
        log.info(Strings.repeat((String)"=", (int)80));
        log.info("FINISHED: {}: {}", (Object)description.getClassName(), (Object)description.getMethodName());
        log.info(Strings.repeat((String)"=", (int)80));
    }

    protected void failed(Throwable e, Description description) {
        log.info(Strings.repeat((String)"=", (int)80));
        log.info("FAILED  : {} {}", (Object)description.getClassName(), (Object)description.getMethodName());
        log.info("Exception", e);
        log.info(Strings.repeat((String)"=", (int)80));
    }

    private void setupFileLogging(String name) {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext context = rootLogger.getLoggerContext();
        context.reset();
        FileAppender fileAppender = new FileAppender();
        String ts = new SimpleDateFormat("yyyyMMdd'T'HHmmss.SSS").format(new Date());
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 2)[0];
        Path directory = Paths.get(System.getProperty("logDir", "/tmp/helios-test/log/"), new String[0]);
        String filename = String.format("%s-%s-%s.log", ts, name, pid);
        Path file = directory.resolve(filename);
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setContext((Context)context);
        ple.setPattern("%d{HH:mm:ss.SSS} %-5level %logger{1} %F:%L - %msg%n");
        ple.start();
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setFile(file.toString());
        fileAppender.setContext((Context)context);
        fileAppender.start();
        rootLogger.setLevel(Level.DEBUG);
        rootLogger.addAppender((Appender)fileAppender);
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.configureLogger("org.eclipse.jetty", Level.ERROR);
        this.configureLogger("org.apache.curator", Level.ERROR);
        this.configureLogger("org.apache.zookeeper", Level.ERROR);
        this.configureLogger("com.yammer.metrics", Level.ERROR);
        this.configureLogger("com.spotify.helios", Level.DEBUG);
    }

    private void configureLogger(String name, Level level) {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)name);
        logger.setLevel(level);
    }
}

