/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableList;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.ThrottleState;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class ImageMissingTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        HeliosClient client = this.defaultClient();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "this_sould_not_exist", (List<String>)ImmutableList.of((Object)"/bin/true"));
        this.deployJob(jobId, this.testHost());
        this.awaitJobThrottle(client, this.testHost(), jobId, ThrottleState.IMAGE_MISSING, 200, TimeUnit.SECONDS);
        HostStatus hostStatus = (HostStatus)client.hostStatus(this.testHost()).get();
        TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
        Assert.assertEquals((Object)TaskStatus.State.FAILED, (Object)taskStatus.getState());
    }
}

