/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.helios.Polling;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.common.protocol.SetGoalResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class AgentRestartTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        DefaultDockerClient dockerClient = new DefaultDockerClient(DOCKER_HOST.uri());
        final HeliosClient client = this.defaultClient();
        AgentMain agent1 = this.startDefaultAgent(this.testHost(), new String[0]);
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        final JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        this.awaitHostRegistered(client, this.testHost(), 10, TimeUnit.MINUTES);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        final TaskStatus firstTaskStatus = this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
        Assert.assertEquals((Object)job, (Object)firstTaskStatus.getJob());
        Assert.assertEquals((long)1L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
        Assert.assertTrue((boolean)dockerClient.inspectContainer(firstTaskStatus.getContainerId()).state().running());
        agent1.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.DOWN, 10, TimeUnit.MINUTES);
        AgentMain agent2 = this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        Thread.sleep(5000L);
        HostStatus hostStatus = (HostStatus)client.hostStatus(this.testHost()).get();
        TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
        if (firstTaskStatus.getState() == TaskStatus.State.PULLING_IMAGE) {
            TaskStatus.State state = taskStatus.getState();
            Assert.assertTrue((state == TaskStatus.State.RUNNING || state == TaskStatus.State.PULLING_IMAGE ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)TaskStatus.State.RUNNING, (Object)taskStatus.getState());
        }
        Assert.assertEquals((Object)firstTaskStatus.getContainerId(), (Object)taskStatus.getContainerId());
        Assert.assertEquals((long)1L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
        Assert.assertTrue((boolean)dockerClient.inspectContainer(firstTaskStatus.getContainerId()).state().running());
        agent2.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.DOWN, 10, TimeUnit.MINUTES);
        dockerClient.killContainer(firstTaskStatus.getContainerId());
        Assert.assertEquals((long)0L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
        AgentMain agent3 = this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        final TaskStatus secondTaskStatus = (TaskStatus)Polling.await((long)10L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)client.hostStatus(AgentRestartTest.this.testHost()).get();
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                return taskStatus != null && taskStatus.getContainerId() != null && taskStatus.getState() == TaskStatus.State.RUNNING && !taskStatus.getContainerId().equals(firstTaskStatus.getContainerId()) ? taskStatus : null;
            }
        });
        Assert.assertEquals((long)1L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
        Assert.assertTrue((boolean)dockerClient.inspectContainer(secondTaskStatus.getContainerId()).state().running());
        agent3.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.DOWN, 10, TimeUnit.MINUTES);
        dockerClient.killContainer(secondTaskStatus.getContainerId());
        AgentRestartTest.removeContainer((DockerClient)dockerClient, secondTaskStatus.getContainerId());
        AgentMain agent4 = this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        TaskStatus thirdTaskStatus = (TaskStatus)Polling.await((long)10L, (TimeUnit)TimeUnit.MINUTES, (Callable)new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                HostStatus hostStatus = (HostStatus)client.hostStatus(AgentRestartTest.this.testHost()).get();
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                return taskStatus != null && taskStatus.getContainerId() != null && taskStatus.getState() == TaskStatus.State.RUNNING && !taskStatus.getContainerId().equals(secondTaskStatus.getContainerId()) ? taskStatus : null;
            }
        });
        Assert.assertEquals((long)1L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
        Assert.assertTrue((boolean)dockerClient.inspectContainer(thirdTaskStatus.getContainerId()).state().running());
        agent4.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.DOWN, 10, TimeUnit.MINUTES);
        SetGoalResponse stopped = (SetGoalResponse)client.setGoal(Deployment.of((JobId)jobId, (Goal)Goal.STOP), this.testHost()).get();
        Assert.assertEquals((Object)SetGoalResponse.Status.OK, (Object)stopped.getStatus());
        AgentMain agent5 = this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.STOPPED, 10, TimeUnit.MINUTES);
        Assert.assertEquals((long)0L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
        agent5.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.DOWN, 10, TimeUnit.MINUTES);
        SetGoalResponse started = (SetGoalResponse)client.setGoal(Deployment.of((JobId)jobId, (Goal)Goal.START), this.testHost()).get();
        Assert.assertEquals((Object)SetGoalResponse.Status.OK, (Object)started.getStatus());
        AgentMain agent6 = this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 10, TimeUnit.MINUTES);
        Assert.assertEquals((long)1L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
        agent6.stopAsync().awaitTerminated();
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.DOWN, 10, TimeUnit.MINUTES);
        JobUndeployResponse undeployed = (JobUndeployResponse)client.undeploy(jobId, this.testHost()).get();
        Assert.assertEquals((Object)JobUndeployResponse.Status.OK, (Object)undeployed.getStatus());
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        this.awaitTaskGone(client, this.testHost(), jobId, 10L, TimeUnit.MINUTES);
        Assert.assertEquals((long)0L, (long)this.listContainers((DockerClient)dockerClient, this.testTag).size());
    }
}

