/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Splitter;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ContainerHostNameTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        try (DefaultDockerClient dockerClient = new DefaultDockerClient(DOCKER_HOST.uri());){
            String log;
            List<String> command = Arrays.asList("hostname", "-f");
            JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox", command);
            this.deployJob(jobId, this.testHost());
            TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
            try (LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParameter[]{DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR});){
                log = logs.readFully();
            }
            MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)this.testHost()));
        }
    }

    @Test
    public void testLength() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        try (DefaultDockerClient dockerClient = new DefaultDockerClient(DOCKER_HOST.uri());){
            String log;
            List<String> command = Arrays.asList("hostname", "-f");
            String jobName = this.testJobName + "01234567890123456789012345678901234567890123456789012345678901234567890";
            JobId jobId = this.createJob(jobName, this.testJobVersion, "busybox", command);
            this.deployJob(jobId, this.testHost());
            TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
            try (LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParameter[]{DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR});){
                log = logs.readFully();
            }
            List hostnameParts = Splitter.on((String)".").splitToList((CharSequence)log.trim());
            int firstPartLen = ((String)hostnameParts.get(0)).length();
            Assert.assertTrue((String)String.format("first part of host name should be <= 32 long, was %s", firstPartLen), (firstPartLen <= 32 ? 1 : 0) != 0);
        }
    }
}

