/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class JobListTest
extends SystemTestBase {
    private static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 10, TimeUnit.MINUTES);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox", IDLE_COMMAND);
        String result1 = this.cli("jobs", "ob_", "--json");
        Map resultObj1 = (Map)OBJECT_MAPPER.readValue(result1, MAP_TYPE);
        Assert.assertFalse((boolean)resultObj1.isEmpty());
        Map.Entry firstEntry = (Map.Entry)Iterables.get(resultObj1.entrySet(), (int)0);
        Assert.assertEquals((Object)jobId.toString(), firstEntry.getKey());
        String result2 = this.cli("jobs", "FramAZaMaWonTF1nD", "--json");
        try {
            Map resultObj2 = (Map)OBJECT_MAPPER.readValue(result2, MAP_TYPE);
            Assert.assertTrue((boolean)resultObj2.isEmpty());
        }
        catch (JsonParseException e) {
            // empty catch block
        }
    }
}

