/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.spotify.helios.Polling;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LabelTest
extends SystemTestBase {
    @Test
    public void testHostStatus() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), "--labels", "role=foo", "xyz=123");
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Map labels = (Map)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                Map status = (Map)Json.read((String)LabelTest.this.cli("hosts", LabelTest.this.testHost(), "--json"), (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
                Map labels = ((HostStatus)status.get(LabelTest.this.testHost())).getLabels();
                if (labels != null && !labels.isEmpty()) {
                    return labels;
                }
                return null;
            }
        });
        Assert.assertEquals((Object)ImmutableMap.of((Object)"role", (Object)"foo", (Object)"xyz", (Object)"123"), (Object)labels);
    }

    @Test
    public void testCliHosts() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), "--labels", "role=foo", "xyz=123");
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                Map status = (Map)Json.read((String)LabelTest.this.cli("hosts", LabelTest.this.testHost(), "--json"), (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
                Map labels = ((HostStatus)status.get(LabelTest.this.testHost())).getLabels();
                if (labels != null && !labels.isEmpty()) {
                    return labels;
                }
                return null;
            }
        });
        Assert.assertThat((Object)this.cli("hosts", "--labels", "role=foo"), (Matcher)CoreMatchers.containsString((String)this.testHost()));
        Assert.assertThat((Object)this.cli("hosts", "--labels", "xyz=123"), (Matcher)CoreMatchers.containsString((String)this.testHost()));
        Assert.assertThat((Object)this.cli("hosts", "--labels", "role=foo", "xyz=123"), (Matcher)CoreMatchers.containsString((String)this.testHost()));
        Assert.assertThat((Object)this.cli("hosts", "--labels", "role=doesnt_exist"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.testHost())));
        Assert.assertThat((Object)this.cli("hosts", "--labels", "role=doesnt_exist", "xyz=123"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.testHost())));
    }
}

