/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class UndeployRaceTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        String agentId = "test-agent-id";
        final HeliosClient client = this.defaultClient();
        client.registerHost(this.testHost(), "test-agent-id");
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox:latest").setCommand(IDLE_COMMAND).build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                List hosts = (List)client.listHosts().get();
                if (hosts.contains(UndeployRaceTest.this.testHost())) {
                    return UndeployRaceTest.this.testHost();
                }
                return null;
            }
        });
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        JobUndeployResponse undeployed = (JobUndeployResponse)client.undeploy(jobId, this.testHost()).get();
        Assert.assertEquals((Object)JobUndeployResponse.Status.OK, (Object)undeployed.getStatus());
        this.startDefaultAgent(this.testHost(), "--id", "test-agent-id");
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        this.awaitTaskGone(client, this.testHost(), jobId, 400L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)((JobDeleteResponse)client.deleteJob(jobId).get()).getStatus());
    }
}

