/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperClusterIdTest
extends SystemTestBase {
    @Override
    public void baseSetup() throws Exception {
        super.baseSetup();
    }

    @Test
    public void testZooKeeperClient() throws Exception {
        this.zk().curator().newNamespaceAwareEnsurePath(Paths.configId((String)this.zkClusterId)).ensure(this.zk().curator().getZookeeperClient());
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework curator = CuratorFrameworkFactory.builder().retryPolicy((RetryPolicy)retryPolicy).connectString(this.zk().connectString()).build();
        DefaultZooKeeperClient client = new DefaultZooKeeperClient(curator, this.zkClusterId);
        client.start();
        client.create("/test");
        client.delete(Paths.configId((String)this.zkClusterId));
        Thread.sleep(500L);
        try {
            client.ensurePath(Paths.configJobs());
            Assert.fail((String)"ZooKeeper operation should have failed because cluster ID was removed");
        }
        catch (IllegalStateException ignore) {
            // empty catch block
        }
    }

    @Test
    public void testMaster() throws Exception {
        this.startDefaultMaster("--zk-cluster-id=" + this.zkClusterId);
        HeliosClient client = this.defaultClient();
        client.jobs().get();
        this.zk().curator().delete().forPath(Paths.configId((String)this.zkClusterId));
        try {
            client.jobs().get();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"500"));
        }
    }

    @Test
    public void testAgent() throws Exception {
        this.startDefaultMaster("--zk-cluster-id=" + this.zkClusterId);
        this.startDefaultAgent(this.testHost(), "--zk-cluster-id=" + this.zkClusterId);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox", IDLE_COMMAND);
        this.deployJob(jobId, this.testHost());
        TaskStatus runningStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.RUNNING);
        final String containerId = runningStatus.getContainerId();
        this.zk().curator().delete().deletingChildrenIfNeeded().forPath("/config");
        Thread.sleep(1000L);
        try (DockerClient docker = this.getNewDockerClient();){
            List containers = docker.listContainers(new DockerClient.ListContainersParam[0]);
            CustomTypeSafeMatcher<Container> containerIdMatcher = new CustomTypeSafeMatcher<Container>("Container with id " + containerId){

                protected boolean matchesSafely(Container container) {
                    return container.id().equals(containerId);
                }
            };
            this.assertContainersMatch(containers, containerIdMatcher);
        }
    }

    private void assertContainersMatch(List<Container> containers, CustomTypeSafeMatcher<Container> containerIdMatcher) {
        Assert.assertThat(containers, (Matcher)Matchers.hasItems((Matcher[])new CustomTypeSafeMatcher[]{containerIdMatcher}));
    }
}

