/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.system.SystemTestBase;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JobRemoveTest
extends SystemTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = JobRemoveTest.this.cli("masters", new String[0]);
                return output.contains(JobRemoveTest.this.masterName()) ? output : null;
            }
        });
    }

    private Boolean awaitJobUndeployed(final HeliosClient client, final String host, final JobId jobId, int timeout, TimeUnit timeunit) throws Exception {
        return (Boolean)Polling.await((long)timeout, (TimeUnit)timeunit, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                HostStatus hostStatus = (HostStatus)JobRemoveTest.this.getOrNull(client.hostStatus(host));
                if (hostStatus == null) {
                    return null;
                }
                TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId);
                return taskStatus == null ? Boolean.valueOf(true) : null;
            }
        });
    }

    @Test
    public void testRemoveJobWithoutHistory() throws Exception {
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND);
        JobDeleteResponse response = (JobDeleteResponse)this.defaultClient().deleteJob(jobId).get(40L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)response.getStatus());
    }

    @Test
    public void testRemoveJobDeletesHistory() throws Exception {
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND);
        this.deployJob(jobId, this.testHost());
        this.awaitJobState(this.defaultClient(), this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.undeployJob(jobId, this.testHost());
        this.awaitJobUndeployed(this.defaultClient(), this.testHost(), jobId, 400, TimeUnit.SECONDS);
        ZooKeeperClient zkClient = new ZooKeeperClientProvider((ZooKeeperClient)new DefaultZooKeeperClient(this.zk().curatorWithSuperAuth()), ZooKeeperModelReporter.noop()).get("test-client");
        Assert.assertNotNull((Object)zkClient.stat(Paths.historyJob((JobId)jobId)));
        JobDeleteResponse response = (JobDeleteResponse)this.defaultClient().deleteJob(jobId).get(40L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)response.getStatus());
        Assert.assertNull((Object)zkClient.stat(Paths.historyJob((JobId)jobId)));
    }
}

