/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetworkModeTest
extends SystemTestBase {
    private HeliosClient client;
    private Job job;
    private static final String NETWORK_MODE = "host";

    @Before
    public void setup() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox:latest").setNetworkMode(NETWORK_MODE).setCommand(IDLE_COMMAND).build();
    }

    @Test
    public void test() throws Exception {
        CreateJobResponse created = (CreateJobResponse)this.client.createJob(this.job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        JobId jobId = this.job.getId();
        this.awaitHostRegistered(this.client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)this.client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        TaskStatus taskStatus = this.awaitJobState(this.client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        try (DockerClient docker = this.getNewDockerClient();){
            HostConfig hostConfig = docker.inspectContainer(taskStatus.getContainerId()).hostConfig();
            Assert.assertEquals((Object)NETWORK_MODE, (Object)hostConfig.networkMode());
        }
    }
}

