/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class MultipleHostsTest
extends SystemTestBase {
    @Test
    public void testHostStatuses() throws Exception {
        String aHost = this.testHost() + "a";
        String bHost = this.testHost() + "b";
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(aHost, new String[0]);
        this.startDefaultAgent(bHost, new String[0]);
        this.awaitHostStatus(aHost, HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        this.awaitHostStatus(bHost, HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        Map cliStatuses = (Map)new ObjectMapper().readValue(this.cli("hosts", "--json"), (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
        Assert.assertTrue((String)("status must contain key for " + aHost), (boolean)cliStatuses.containsKey(aHost));
        Assert.assertTrue((String)("status must contain key for " + bHost), (boolean)cliStatuses.containsKey(bHost));
        HeliosClient client = this.defaultClient();
        Map clientStatuses = (Map)client.hostStatuses((List)ImmutableList.of((Object)aHost, (Object)bHost)).get();
        Assert.assertTrue((String)("status must contain key for " + aHost), (boolean)clientStatuses.containsKey(aHost));
        Assert.assertTrue((String)("status must contain key for " + bHost), (boolean)clientStatuses.containsKey(bHost));
    }
}

