/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.helios.Polling;
import com.spotify.helios.agent.AgentMain;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class MultiplePortJobTest
extends SystemTestBase {
    private final int externalPort1;
    private final int externalPort2;

    public MultiplePortJobTest() {
        this.externalPort1 = this.temporaryPorts.localPort("external-1");
        this.externalPort2 = this.temporaryPorts.localPort("external-2");
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        Range portRange = this.temporaryPorts.localPortRange("agent1", 2);
        AgentMain agent1 = this.startDefaultAgent(this.testHost(), "--port-range=" + portRange.lowerEndpoint() + ":" + portRange.upperEndpoint());
        try (DockerClient dockerClient = this.getNewDockerClient();){
            final HeliosClient client = this.defaultClient();
            this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
            ImmutableMap ports1 = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.externalPort1));
            ImmutableMap expectedMapping1 = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711, (Integer)((Integer)portRange.lowerEndpoint())), (Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.externalPort1));
            ImmutableMap ports2 = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.externalPort2));
            ImmutableMap expectedMapping2 = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711, (Integer)((Integer)portRange.lowerEndpoint() + 1)), (Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.externalPort2));
            final JobId jobId1 = this.createJob(this.testJobName + 1, this.testJobVersion, "busybox", IDLE_COMMAND, Job.EMPTY_ENV, (Map<String, PortMapping>)ports1);
            Assert.assertNotNull((Object)jobId1);
            this.deployJob(jobId1, this.testHost());
            final TaskStatus firstTaskStatus1 = this.awaitJobState(client, this.testHost(), jobId1, TaskStatus.State.RUNNING, 200, TimeUnit.SECONDS);
            final JobId jobId2 = this.createJob(this.testJobName + 2, this.testJobVersion, "busybox", IDLE_COMMAND, Job.EMPTY_ENV, (Map<String, PortMapping>)ports2);
            Assert.assertNotNull((Object)jobId2);
            this.deployJob(jobId2, this.testHost());
            final TaskStatus firstTaskStatus2 = this.awaitJobState(client, this.testHost(), jobId2, TaskStatus.State.RUNNING, 200, TimeUnit.SECONDS);
            Assert.assertEquals((Object)expectedMapping1, (Object)firstTaskStatus1.getPorts());
            Assert.assertEquals((Object)expectedMapping2, (Object)firstTaskStatus2.getPorts());
            dockerClient.killContainer(firstTaskStatus1.getContainerId());
            TaskStatus restartedTaskStatus1 = (TaskStatus)Polling.await((long)200L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TaskStatus>(){

                @Override
                public TaskStatus call() throws Exception {
                    HostStatus hostStatus = (HostStatus)client.hostStatus(MultiplePortJobTest.this.testHost()).get();
                    TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId1);
                    return taskStatus != null && taskStatus.getState() == TaskStatus.State.RUNNING && !Objects.equals(taskStatus.getContainerId(), firstTaskStatus1.getContainerId()) ? taskStatus : null;
                }
            });
            Assert.assertEquals((Object)expectedMapping1, (Object)restartedTaskStatus1.getPorts());
            agent1.stopAsync().awaitTerminated();
            dockerClient.killContainer(firstTaskStatus2.getContainerId());
            this.startDefaultAgent(this.testHost(), new String[0]);
            TaskStatus restartedTaskStatus2 = (TaskStatus)Polling.await((long)200L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<TaskStatus>(){

                @Override
                public TaskStatus call() throws Exception {
                    HostStatus hostStatus = (HostStatus)client.hostStatus(MultiplePortJobTest.this.testHost()).get();
                    TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(jobId2);
                    return taskStatus != null && taskStatus.getState() == TaskStatus.State.RUNNING && !Objects.equals(taskStatus.getContainerId(), firstTaskStatus2.getContainerId()) ? taskStatus : null;
                }
            });
            Assert.assertEquals((Object)expectedMapping2, (Object)restartedTaskStatus2.getPorts());
        }
    }

    @Test
    public void testPortEnvVars() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 200, TimeUnit.SECONDS);
        ImmutableMap ports = ImmutableMap.of((Object)"bar", (Object)PortMapping.of((int)4712, (Integer)this.externalPort1));
        try (DockerClient dockerClient = this.getNewDockerClient();){
            String log;
            JobId jobId = this.createJob(this.testJobName + 1, this.testJobVersion, "busybox", Arrays.asList("sh", "-c", "echo $HELIOS_PORT_bar"), Job.EMPTY_ENV, (Map<String, PortMapping>)ports);
            this.deployJob(jobId, this.testHost());
            TaskStatus taskStatus = this.awaitTaskState(jobId, this.testHost(), TaskStatus.State.EXITED);
            try (LogStream logs = dockerClient.logs(taskStatus.getContainerId(), new DockerClient.LogsParameter[]{DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR});){
                log = logs.readFully();
            }
            Assert.assertEquals((Object)(this.testHost() + ":" + this.externalPort1), (Object)log.trim());
        }
    }
}

